@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Model sweeping and hyperparameter sweeping related settings.
 * @property earlyTermination Type of early termination policy.
 * @property samplingAlgorithm [Required] Type of the hyperparameter sampling algorithms.
 */
public data class ImageSweepSettingsResponse(
    public val earlyTermination: Any? = null,
    public val samplingAlgorithm: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ImageSweepSettingsResponse):
            ImageSweepSettingsResponse = ImageSweepSettingsResponse(
            earlyTermination = javaType.earlyTermination().map({ args0 -> args0 }).orElse(null),
            samplingAlgorithm = javaType.samplingAlgorithm(),
        )
    }
}
