@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Dto object representing index column
 * @property columnName Specifies the column name
 * @property dataType Specifies the data type
 */
public data class IndexColumnResponse(
    public val columnName: String? = null,
    public val dataType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.IndexColumnResponse):
            IndexColumnResponse = IndexColumnResponse(
            columnName = javaType.columnName().map({ args0 -> args0 }).orElse(null),
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
