@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Kubernetes properties
 * @property defaultInstanceType Default instance type
 * @property extensionInstanceReleaseTrain Extension instance release train.
 * @property extensionPrincipalId Extension principal-id.
 * @property instanceTypes Instance Type Schema
 * @property namespace Compute namespace
 * @property relayConnectionString Relay connection string.
 * @property serviceBusConnectionString ServiceBus connection string.
 * @property vcName VC name.
 */
public data class KubernetesPropertiesResponse(
    public val defaultInstanceType: String? = null,
    public val extensionInstanceReleaseTrain: String? = null,
    public val extensionPrincipalId: String? = null,
    public val instanceTypes: Map<String, InstanceTypeSchemaResponse>? = null,
    public val namespace: String? = null,
    public val relayConnectionString: String? = null,
    public val serviceBusConnectionString: String? = null,
    public val vcName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.KubernetesPropertiesResponse):
            KubernetesPropertiesResponse = KubernetesPropertiesResponse(
            defaultInstanceType = javaType.defaultInstanceType().map({ args0 -> args0 }).orElse(null),
            extensionInstanceReleaseTrain = javaType.extensionInstanceReleaseTrain().map({ args0 ->
                args0
            }).orElse(null),
            extensionPrincipalId = javaType.extensionPrincipalId().map({ args0 -> args0 }).orElse(null),
            instanceTypes = javaType.instanceTypes().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearningservices.kotlin.outputs.InstanceTypeSchemaResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            relayConnectionString = javaType.relayConnectionString().map({ args0 -> args0 }).orElse(null),
            serviceBusConnectionString = javaType.serviceBusConnectionString().map({ args0 ->
                args0
            }).orElse(null),
            vcName = javaType.vcName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
