@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessToken
 * @property expiresIn
 * @property hostName
 * @property notebookResourceId
 * @property publicDns
 * @property refreshToken
 * @property scope
 * @property tokenType
 */
public data class ListWorkspaceNotebookAccessTokenResult(
    public val accessToken: String,
    public val expiresIn: Int,
    public val hostName: String,
    public val notebookResourceId: String,
    public val publicDns: String,
    public val refreshToken: String,
    public val scope: String,
    public val tokenType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ListWorkspaceNotebookAccessTokenResult):
            ListWorkspaceNotebookAccessTokenResult = ListWorkspaceNotebookAccessTokenResult(
            accessToken = javaType.accessToken(),
            expiresIn = javaType.expiresIn(),
            hostName = javaType.hostName(),
            notebookResourceId = javaType.notebookResourceId(),
            publicDns = javaType.publicDns(),
            refreshToken = javaType.refreshToken(),
            scope = javaType.scope(),
            tokenType = javaType.tokenType(),
        )
    }
}
