@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Literal input type.
 * @property description Description for the input.
 * @property jobInputType Enum to determine the Job Input Type.
 * Expected value is 'literal'.
 * @property value [Required] Literal value for the input.
 */
public data class LiteralJobInputResponse(
    public val description: String? = null,
    public val jobInputType: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.LiteralJobInputResponse):
            LiteralJobInputResponse = LiteralJobInputResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            jobInputType = javaType.jobInputType(),
            `value` = javaType.`value`(),
        )
    }
}
