@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Private Endpoint destination for a Private Endpoint Outbound Rule for the managed network of a machine learning workspace.
 * @property serviceResourceId
 * @property sparkEnabled
 * @property sparkStatus Status of a managed network Outbound Rule of a machine learning workspace.
 * @property subresourceTarget
 */
public data class PrivateEndpointDestinationResponse(
    public val serviceResourceId: String? = null,
    public val sparkEnabled: Boolean? = null,
    public val sparkStatus: String? = null,
    public val subresourceTarget: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.PrivateEndpointDestinationResponse):
            PrivateEndpointDestinationResponse = PrivateEndpointDestinationResponse(
            serviceResourceId = javaType.serviceResourceId().map({ args0 -> args0 }).orElse(null),
            sparkEnabled = javaType.sparkEnabled().map({ args0 -> args0 }).orElse(null),
            sparkStatus = javaType.sparkStatus().map({ args0 -> args0 }).orElse(null),
            subresourceTarget = javaType.subresourceTarget().map({ args0 -> args0 }).orElse(null),
        )
    }
}
