@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The workflow trigger recurrence for ComputeStartStop schedule type.
 * @property frequency [Required] The frequency to trigger schedule.
 * @property interval [Required] Specifies schedule interval in conjunction with frequency
 * @property schedule [Required] The recurrence schedule.
 * @property startTime The start time in yyyy-MM-ddTHH:mm:ss format.
 * @property timeZone Specifies time zone in which the schedule runs.
 * TimeZone should follow Windows time zone format. Refer: https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
 */
public data class RecurrenceResponse(
    public val frequency: String? = null,
    public val interval: Int? = null,
    public val schedule: RecurrenceScheduleResponse? = null,
    public val startTime: String? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.RecurrenceResponse):
            RecurrenceResponse = RecurrenceResponse(
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.RecurrenceScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
