@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id A system assigned id for the schedule.
 * @property provisioningStatus The current deployment state of schedule.
 * @property status Is the schedule enabled or disabled?
 */
public data class ScheduleBaseResponse(
    public val id: String? = null,
    public val provisioningStatus: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ScheduleBaseResponse):
            ScheduleBaseResponse = ScheduleBaseResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            provisioningStatus = javaType.provisioningStatus().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
