@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Suppress

/**
 * Customized setup scripts
 * @property creationScript Script that's run only once during provision of the compute.
 * @property startupScript Script that's run every time the machine starts.
 */
public data class ScriptsToExecuteResponse(
    public val creationScript: ScriptReferenceResponse? = null,
    public val startupScript: ScriptReferenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.ScriptsToExecuteResponse):
            ScriptsToExecuteResponse = ScriptsToExecuteResponse(
            creationScript = javaType.creationScript().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ScriptReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startupScript = javaType.startupScript().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ScriptReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
