@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Any
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Advances setting to customize StackEnsemble run.
 * @property stackMetaLearnerKWargs Optional parameters to pass to the initializer of the meta-learner.
 * @property stackMetaLearnerTrainPercentage Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training the meta-learner. Default value is 0.2.
 * @property stackMetaLearnerType The meta-learner is a model trained on the output of the individual heterogeneous models.
 */
public data class StackEnsembleSettingsResponse(
    public val stackMetaLearnerKWargs: Any? = null,
    public val stackMetaLearnerTrainPercentage: Double? = null,
    public val stackMetaLearnerType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.StackEnsembleSettingsResponse):
            StackEnsembleSettingsResponse = StackEnsembleSettingsResponse(
            stackMetaLearnerKWargs = javaType.stackMetaLearnerKWargs().map({ args0 -> args0 }).orElse(null),
            stackMetaLearnerTrainPercentage = javaType.stackMetaLearnerTrainPercentage().map({ args0 ->
                args0
            }).orElse(null),
            stackMetaLearnerType = javaType.stackMetaLearnerType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
