@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoPauseProperties Auto pause properties.
 * @property autoScaleProperties Auto scale properties.
 * @property nodeCount The number of compute nodes currently assigned to the compute.
 * @property nodeSize Node size.
 * @property nodeSizeFamily Node size family.
 * @property poolName Pool name.
 * @property resourceGroup Name of the resource group in which workspace is located.
 * @property sparkVersion Spark version.
 * @property subscriptionId Azure subscription identifier.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class SynapseSparkResponseProperties(
    public val autoPauseProperties: AutoPausePropertiesResponse? = null,
    public val autoScaleProperties: AutoScalePropertiesResponse? = null,
    public val nodeCount: Int? = null,
    public val nodeSize: String? = null,
    public val nodeSizeFamily: String? = null,
    public val poolName: String? = null,
    public val resourceGroup: String? = null,
    public val sparkVersion: String? = null,
    public val subscriptionId: String? = null,
    public val workspaceName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SynapseSparkResponseProperties):
            SynapseSparkResponseProperties = SynapseSparkResponseProperties(
            autoPauseProperties = javaType.autoPauseProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoPausePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoScaleProperties = javaType.autoScaleProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.AutoScalePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nodeCount = javaType.nodeCount().map({ args0 -> args0 }).orElse(null),
            nodeSize = javaType.nodeSize().map({ args0 -> args0 }).orElse(null),
            nodeSizeFamily = javaType.nodeSizeFamily().map({ args0 -> args0 }).orElse(null),
            poolName = javaType.poolName().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            sparkVersion = javaType.sparkVersion().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            workspaceName = javaType.workspaceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
