@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allowBlobPublicAccess Public blob access allowed
 * @property armResourceId This is populated once the storage account is created.
 * @property storageAccountHnsEnabled HNS enabled for storage account
 * @property storageAccountName Name of the storage account
 * @property storageAccountType Allowed values:
 * "Standard_LRS",
 * "Standard_GRS",
 * "Standard_RAGRS",
 * "Standard_ZRS",
 * "Standard_GZRS",
 * "Standard_RAGZRS",
 * "Premium_LRS",
 * "Premium_ZRS"
 */
public data class SystemCreatedStorageAccountResponse(
    public val allowBlobPublicAccess: Boolean? = null,
    public val armResourceId: ArmResourceIdResponse? = null,
    public val storageAccountHnsEnabled: Boolean? = null,
    public val storageAccountName: String? = null,
    public val storageAccountType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.SystemCreatedStorageAccountResponse):
            SystemCreatedStorageAccountResponse = SystemCreatedStorageAccountResponse(
            allowBlobPublicAccess = javaType.allowBlobPublicAccess().map({ args0 -> args0 }).orElse(null),
            armResourceId = javaType.armResourceId().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ArmResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccountHnsEnabled = javaType.storageAccountHnsEnabled().map({ args0 -> args0 }).orElse(null),
            storageAccountName = javaType.storageAccountName().map({ args0 -> args0 }).orElse(null),
            storageAccountType = javaType.storageAccountType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
