@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User who created.
 * @property userAltSecId A user alternate sec id. This represents the user in a different identity provider system Eg.1:live.com:puid
 * @property userIdp A user identity provider. Eg live.com
 * @property userIss The issuer which issued the token for this user.
 * @property userName  A user's full name or a service principal's app ID.
 * @property userObjectId A user or service principal's object ID..
 * @property userPuId A user or service principal's PuID.
 * @property userTenantId A user or service principal's tenant ID.
 */
public data class UserInfoResponse(
    public val userAltSecId: String? = null,
    public val userIdp: String? = null,
    public val userIss: String? = null,
    public val userName: String? = null,
    public val userObjectId: String? = null,
    public val userPuId: String? = null,
    public val userTenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.outputs.UserInfoResponse):
            UserInfoResponse = UserInfoResponse(
            userAltSecId = javaType.userAltSecId().map({ args0 -> args0 }).orElse(null),
            userIdp = javaType.userIdp().map({ args0 -> args0 }).orElse(null),
            userIss = javaType.userIss().map({ args0 -> args0 }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
            userObjectId = javaType.userObjectId().map({ args0 -> args0 }).orElse(null),
            userPuId = javaType.userPuId().map({ args0 -> args0 }).orElse(null),
            userTenantId = javaType.userTenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
