@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConfigurationAssignment].
 */
@PulumiTagMarker
public class ConfigurationAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationAssignmentArgs = ConfigurationAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationAssignmentArgsBuilder.() -> Unit) {
        val builder = ConfigurationAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.maintenance.ConfigurationAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationAssignment(builtJavaResource)
    }
}

/**
 * Configuration Assignment
 * Azure REST API version: 2022-11-01-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2023-04-01, 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### ConfigurationAssignments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationAssignment = new AzureNative.Maintenance.ConfigurationAssignment("configurationAssignment", new()
 *     {
 *         ConfigurationAssignmentName = "workervmConfiguration",
 *         MaintenanceConfigurationId = "/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1",
 *         ProviderName = "Microsoft.Compute",
 *         ResourceGroupName = "examplerg",
 *         ResourceName = "smdtest1",
 *         ResourceType = "virtualMachineScaleSets",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maintenance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maintenance.NewConfigurationAssignment(ctx, "configurationAssignment", &maintenance.ConfigurationAssignmentArgs{
 * 			ConfigurationAssignmentName: pulumi.String("workervmConfiguration"),
 * 			MaintenanceConfigurationId:  pulumi.String("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1"),
 * 			ProviderName:                pulumi.String("Microsoft.Compute"),
 * 			ResourceGroupName:           pulumi.String("examplerg"),
 * 			ResourceName:                pulumi.String("smdtest1"),
 * 			ResourceType:                pulumi.String("virtualMachineScaleSets"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignment;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationAssignment = new ConfigurationAssignment("configurationAssignment", ConfigurationAssignmentArgs.builder()
 *             .configurationAssignmentName("workervmConfiguration")
 *             .maintenanceConfigurationId("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1")
 *             .providerName("Microsoft.Compute")
 *             .resourceGroupName("examplerg")
 *             .resourceName("smdtest1")
 *             .resourceType("virtualMachineScaleSets")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maintenance:ConfigurationAssignment workervmConfiguration /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}
 * ```
 */
public class ConfigurationAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.maintenance.ConfigurationAssignment,
) : KotlinCustomResource(javaResource, ConfigurationAssignmentMapper) {
    /**
     * Location of the resource
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maintenance configuration Id
     */
    public val maintenanceConfigurationId: Output<String>?
        get() = javaResource.maintenanceConfigurationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The unique resourceId
     */
    public val resourceId: Output<String>?
        get() = javaResource.resourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Type of the resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConfigurationAssignmentMapper : ResourceMapper<ConfigurationAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.maintenance.ConfigurationAssignment::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationAssignment =
        ConfigurationAssignment(
            javaResource as
                com.pulumi.azurenative.maintenance.ConfigurationAssignment,
        )
}

/**
 * @see [ConfigurationAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationAssignment].
 */
public suspend fun configurationAssignment(
    name: String,
    block: suspend ConfigurationAssignmentResourceBuilder.() -> Unit,
): ConfigurationAssignment {
    val builder = ConfigurationAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationAssignment(name: String): ConfigurationAssignment {
    val builder = ConfigurationAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
