@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin

import com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscriptionArgs.builder
import com.pulumi.azurenative.maintenance.kotlin.inputs.ConfigurationAssignmentFilterPropertiesArgs
import com.pulumi.azurenative.maintenance.kotlin.inputs.ConfigurationAssignmentFilterPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration Assignment
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-09-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### ConfigurationAssignmentsForSubscriptions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var configurationAssignmentsForSubscription = new AzureNative.Maintenance.ConfigurationAssignmentsForSubscription("configurationAssignmentsForSubscription", new()
 *     {
 *         ConfigurationAssignmentName = "workervmConfiguration",
 *         Filter = new AzureNative.Maintenance.Inputs.ConfigurationAssignmentFilterPropertiesArgs
 *         {
 *             Locations = new[]
 *             {
 *                 "Japan East",
 *                 "UK South",
 *             },
 *             ResourceGroups = new[]
 *             {
 *                 "RG1",
 *                 "RG2",
 *             },
 *             ResourceTypes = new[]
 *             {
 *                 "Microsoft.HybridCompute/machines",
 *                 "Microsoft.Compute/virtualMachines",
 *             },
 *             TagSettings = new AzureNative.Maintenance.Inputs.TagSettingsPropertiesArgs
 *             {
 *                 FilterOperator = AzureNative.Maintenance.TagOperators.Any,
 *                 Tags =
 *                 {
 *                     { "tag1", new[]
 *                     {
 *                         "tag1Value1",
 *                         "tag1Value2",
 *                         "tag1Value3",
 *                     } },
 *                     { "tag2", new[]
 *                     {
 *                         "tag2Value1",
 *                         "tag2Value2",
 *                         "tag2Value3",
 *                     } },
 *                 },
 *             },
 *         },
 *         MaintenanceConfigurationId = "/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/maintenance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := maintenance.NewConfigurationAssignmentsForSubscription(ctx, "configurationAssignmentsForSubscription", &maintenance.ConfigurationAssignmentsForSubscriptionArgs{
 * 			ConfigurationAssignmentName: pulumi.String("workervmConfiguration"),
 * 			Filter: maintenance.ConfigurationAssignmentFilterPropertiesResponse{
 * 				Locations: pulumi.StringArray{
 * 					pulumi.String("Japan East"),
 * 					pulumi.String("UK South"),
 * 				},
 * 				ResourceGroups: pulumi.StringArray{
 * 					pulumi.String("RG1"),
 * 					pulumi.String("RG2"),
 * 				},
 * 				ResourceTypes: pulumi.StringArray{
 * 					pulumi.String("Microsoft.HybridCompute/machines"),
 * 					pulumi.String("Microsoft.Compute/virtualMachines"),
 * 				},
 * 				TagSettings: &maintenance.TagSettingsPropertiesArgs{
 * 					FilterOperator: maintenance.TagOperatorsAny,
 * 					Tags: pulumi.StringArrayMap{
 * 						"tag1": pulumi.StringArray{
 * 							pulumi.String("tag1Value1"),
 * 							pulumi.String("tag1Value2"),
 * 							pulumi.String("tag1Value3"),
 * 						},
 * 						"tag2": pulumi.StringArray{
 * 							pulumi.String("tag2Value1"),
 * 							pulumi.String("tag2Value2"),
 * 							pulumi.String("tag2Value3"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			MaintenanceConfigurationId: pulumi.String("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscription;
 * import com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var configurationAssignmentsForSubscription = new ConfigurationAssignmentsForSubscription("configurationAssignmentsForSubscription", ConfigurationAssignmentsForSubscriptionArgs.builder()
 *             .configurationAssignmentName("workervmConfiguration")
 *             .filter(Map.ofEntries(
 *                 Map.entry("locations",
 *                     "Japan East",
 *                     "UK South"),
 *                 Map.entry("resourceGroups",
 *                     "RG1",
 *                     "RG2"),
 *                 Map.entry("resourceTypes",
 *                     "Microsoft.HybridCompute/machines",
 *                     "Microsoft.Compute/virtualMachines"),
 *                 Map.entry("tagSettings", Map.ofEntries(
 *                     Map.entry("filterOperator", "Any"),
 *                     Map.entry("tags", Map.ofEntries(
 *                         Map.entry("tag1",
 *                             "tag1Value1",
 *                             "tag1Value2",
 *                             "tag1Value3"),
 *                         Map.entry("tag2",
 *                             "tag2Value1",
 *                             "tag2Value2",
 *                             "tag2Value3")
 *                     ))
 *                 ))
 *             ))
 *             .maintenanceConfigurationId("/subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourcegroups/examplerg/providers/Microsoft.Maintenance/maintenanceConfigurations/configuration1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:maintenance:ConfigurationAssignmentsForSubscription workervmConfiguration /subscriptions/{subscriptionId}/providers/Microsoft.Maintenance/configurationAssignments/{configurationAssignmentName}
 * ```
 * @property configurationAssignmentName Configuration assignment name
 * @property filter Properties of the configuration assignment
 * @property location Location of the resource
 * @property maintenanceConfigurationId The maintenance configuration Id
 * @property resourceId The unique resourceId
 */
public data class ConfigurationAssignmentsForSubscriptionArgs(
    public val configurationAssignmentName: Output<String>? = null,
    public val filter: Output<ConfigurationAssignmentFilterPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val maintenanceConfigurationId: Output<String>? = null,
    public val resourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscriptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscriptionArgs =
        com.pulumi.azurenative.maintenance.ConfigurationAssignmentsForSubscriptionArgs.builder()
            .configurationAssignmentName(configurationAssignmentName?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceConfigurationId(maintenanceConfigurationId?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationAssignmentsForSubscriptionArgs].
 */
@PulumiTagMarker
public class ConfigurationAssignmentsForSubscriptionArgsBuilder internal constructor() {
    private var configurationAssignmentName: Output<String>? = null

    private var filter: Output<ConfigurationAssignmentFilterPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var maintenanceConfigurationId: Output<String>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Configuration assignment name
     */
    @JvmName("blyojngdkjokejgt")
    public suspend fun configurationAssignmentName(`value`: Output<String>) {
        this.configurationAssignmentName = value
    }

    /**
     * @param value Properties of the configuration assignment
     */
    @JvmName("qlcqyqdptyuuwysw")
    public suspend fun filter(`value`: Output<ConfigurationAssignmentFilterPropertiesArgs>) {
        this.filter = value
    }

    /**
     * @param value Location of the resource
     */
    @JvmName("knibxdawkcsimumv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The maintenance configuration Id
     */
    @JvmName("wxapialpdkuralwu")
    public suspend fun maintenanceConfigurationId(`value`: Output<String>) {
        this.maintenanceConfigurationId = value
    }

    /**
     * @param value The unique resourceId
     */
    @JvmName("clexvyhbmjfewsux")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Configuration assignment name
     */
    @JvmName("lcyfhpvmonyjlfuq")
    public suspend fun configurationAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationAssignmentName = mapped
    }

    /**
     * @param value Properties of the configuration assignment
     */
    @JvmName("bpxuweowxkvahnrn")
    public suspend fun filter(`value`: ConfigurationAssignmentFilterPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Properties of the configuration assignment
     */
    @JvmName("rgmrqvgurlvfqnlc")
    public suspend
    fun filter(argument: suspend ConfigurationAssignmentFilterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfigurationAssignmentFilterPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value Location of the resource
     */
    @JvmName("kuxdjnyycbthuudo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The maintenance configuration Id
     */
    @JvmName("xnwxllcdnptpghdg")
    public suspend fun maintenanceConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceConfigurationId = mapped
    }

    /**
     * @param value The unique resourceId
     */
    @JvmName("vcqerpduarpobswm")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ConfigurationAssignmentsForSubscriptionArgs =
        ConfigurationAssignmentsForSubscriptionArgs(
            configurationAssignmentName = configurationAssignmentName,
            filter = filter,
            location = location,
            maintenanceConfigurationId = maintenanceConfigurationId,
            resourceId = resourceId,
        )
}
