@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentParentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationAssignmentName Configuration assignment name
 * @property providerName Resource provider name
 * @property resourceGroupName Resource group name
 * @property resourceName Resource identifier
 * @property resourceParentName Resource parent identifier
 * @property resourceParentType Resource parent type
 * @property resourceType Resource type
 */
public data class GetConfigurationAssignmentParentPlainArgs(
    public val configurationAssignmentName: String,
    public val providerName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val resourceParentName: String,
    public val resourceParentType: String,
    public val resourceType: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentParentPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentParentPlainArgs =
        com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentParentPlainArgs.builder()
            .configurationAssignmentName(configurationAssignmentName.let({ args0 -> args0 }))
            .providerName(providerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .resourceParentName(resourceParentName.let({ args0 -> args0 }))
            .resourceParentType(resourceParentType.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationAssignmentParentPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationAssignmentParentPlainArgsBuilder internal constructor() {
    private var configurationAssignmentName: String? = null

    private var providerName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var resourceParentName: String? = null

    private var resourceParentType: String? = null

    private var resourceType: String? = null

    /**
     * @param value Configuration assignment name
     */
    @JvmName("vnqmkxeyvrvjwbcy")
    public suspend fun configurationAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationAssignmentName = mapped
    }

    /**
     * @param value Resource provider name
     */
    @JvmName("ulpomgvikhbnknuc")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerName = mapped
    }

    /**
     * @param value Resource group name
     */
    @JvmName("mricwhcickctaykd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource identifier
     */
    @JvmName("gqahciajlkfntmxq")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value Resource parent identifier
     */
    @JvmName("soufknggddtgkuio")
    public suspend fun resourceParentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceParentName = mapped
    }

    /**
     * @param value Resource parent type
     */
    @JvmName("abpadaecsljmeqdg")
    public suspend fun resourceParentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceParentType = mapped
    }

    /**
     * @param value Resource type
     */
    @JvmName("mkmkdopiqqcjygwe")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetConfigurationAssignmentParentPlainArgs =
        GetConfigurationAssignmentParentPlainArgs(
            configurationAssignmentName = configurationAssignmentName ?: throw
                PulumiNullFieldException("configurationAssignmentName"),
            providerName = providerName ?: throw PulumiNullFieldException("providerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            resourceParentName = resourceParentName ?: throw PulumiNullFieldException("resourceParentName"),
            resourceParentType = resourceParentType ?: throw PulumiNullFieldException("resourceParentType"),
            resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        )
}
