@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentsForResourceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationAssignmentName Configuration assignment name
 * @property resourceGroupName Resource group name
 */
public data class GetConfigurationAssignmentsForResourceGroupPlainArgs(
    public val configurationAssignmentName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentsForResourceGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentsForResourceGroupPlainArgs =
        com.pulumi.azurenative.maintenance.inputs.GetConfigurationAssignmentsForResourceGroupPlainArgs.builder()
            .configurationAssignmentName(configurationAssignmentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConfigurationAssignmentsForResourceGroupPlainArgs].
 */
@PulumiTagMarker
public class GetConfigurationAssignmentsForResourceGroupPlainArgsBuilder internal constructor() {
    private var configurationAssignmentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Configuration assignment name
     */
    @JvmName("tatffdieydigtcjy")
    public suspend fun configurationAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationAssignmentName = mapped
    }

    /**
     * @param value Resource group name
     */
    @JvmName("hdsjdkhhfptaaiav")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetConfigurationAssignmentsForResourceGroupPlainArgs =
        GetConfigurationAssignmentsForResourceGroupPlainArgs(
            configurationAssignmentName = configurationAssignmentName ?: throw
                PulumiNullFieldException("configurationAssignmentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
