@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.inputs

import com.pulumi.azurenative.maintenance.inputs.GetMaintenanceConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Resource Group Name
 * @property resourceName Maintenance Configuration Name
 */
public data class GetMaintenanceConfigurationPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.maintenance.inputs.GetMaintenanceConfigurationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.maintenance.inputs.GetMaintenanceConfigurationPlainArgs =
        com.pulumi.azurenative.maintenance.inputs.GetMaintenanceConfigurationPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMaintenanceConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetMaintenanceConfigurationPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Resource Group Name
     */
    @JvmName("awqaxhccingopmed")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Maintenance Configuration Name
     */
    @JvmName("vqdesmkasqxcrhwq")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetMaintenanceConfigurationPlainArgs = GetMaintenanceConfigurationPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
