@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.maintenance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Maintenance configuration record type
 * @property duration Duration of the maintenance window in HH:mm format. If not provided, default value will be used based on maintenance scope provided. Example: 05:00.
 * @property expirationDateTime Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
 * @property extensionProperties Gets or sets extensionProperties of the maintenanceConfiguration
 * @property id Fully qualified identifier of the resource
 * @property installPatches The input parameters to be passed to the patch run operation.
 * @property location Gets or sets location of the resource
 * @property maintenanceScope Gets or sets maintenanceScope of the configuration
 * @property name Name of the resource
 * @property namespace Gets or sets namespace of the resource
 * @property overrides Override Properties for the maintenance Configuration.
 * @property recurEvery Rate at which a Maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules. Daily schedule are formatted as recurEvery: [Frequency as integer]['Day(s)']&#46; If no frequency is provided, the default frequency is 1&#46; Daily schedule examples are recurEvery: Day, recurEvery: 3Days&#46;  Weekly schedule are formatted as recurEvery: [Frequency as integer]['Week(s)'] [Optional comma separated list of weekdays Monday-Sunday]&#46; Weekly schedule examples are recurEvery: 3Weeks, recurEvery: Week Saturday,Sunday&#46; Monthly schedules are formatted as [Frequency as integer]['Month(s)'] [Comma separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First, Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No&#46; of days)]. Offset value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month, recurEvery: 2Months, recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery: Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday Offset6.
 * @property startDateTime Effective start date of the maintenance window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Gets or sets tags of the resource
 * @property timeZone Name of the timezone. List of timezones can be obtained by executing [System&#46;TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
 * @property type Type of the resource
 * @property visibility Gets or sets the visibility of the configuration. The default value is 'Custom'
 */
public data class GetMaintenanceConfigurationResult(
    public val duration: String? = null,
    public val expirationDateTime: String? = null,
    public val extensionProperties: Map<String, String>? = null,
    public val id: String,
    public val installPatches: InputPatchConfigurationResponse? = null,
    public val location: String? = null,
    public val maintenanceScope: String? = null,
    public val name: String,
    public val namespace: String? = null,
    public val overrides: List<MaintenanceOverridePropertiesResponse>? = null,
    public val recurEvery: String? = null,
    public val startDateTime: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val timeZone: String? = null,
    public val type: String,
    public val visibility: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.maintenance.outputs.GetMaintenanceConfigurationResult):
            GetMaintenanceConfigurationResult = GetMaintenanceConfigurationResult(
            duration = javaType.duration().map({ args0 -> args0 }).orElse(null),
            expirationDateTime = javaType.expirationDateTime().map({ args0 -> args0 }).orElse(null),
            extensionProperties = javaType.extensionProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            id = javaType.id(),
            installPatches = javaType.installPatches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.maintenance.kotlin.outputs.InputPatchConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            maintenanceScope = javaType.maintenanceScope().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            overrides = javaType.overrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.maintenance.kotlin.outputs.MaintenanceOverridePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            recurEvery = javaType.recurEvery().map({ args0 -> args0 }).orElse(null),
            startDateTime = javaType.startDateTime().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.maintenance.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            visibility = javaType.visibility().map({ args0 -> args0 }).orElse(null),
        )
    }
}
