@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin

import com.pulumi.azurenative.managedidentity.UserAssignedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes an identity resource.
 * Azure REST API version: 2023-01-31. Prior API version in Azure Native 1.x: 2018-11-30.
 * Other available API versions: 2015-08-31-preview, 2023-07-31-preview.
 * ## Example Usage
 * ### IdentityCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var userAssignedIdentity = new AzureNative.ManagedIdentity.UserAssignedIdentity("userAssignedIdentity", new()
 *     {
 *         Location = "eastus",
 *         ResourceGroupName = "rgName",
 *         ResourceName = "resourceName",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managedidentity/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managedidentity.NewUserAssignedIdentity(ctx, "userAssignedIdentity", &managedidentity.UserAssignedIdentityArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("rgName"),
 * 			ResourceName:      pulumi.String("resourceName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managedidentity.UserAssignedIdentity;
 * import com.pulumi.azurenative.managedidentity.UserAssignedIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var userAssignedIdentity = new UserAssignedIdentity("userAssignedIdentity", UserAssignedIdentityArgs.builder()
 *             .location("eastus")
 *             .resourceGroupName("rgName")
 *             .resourceName("resourceName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managedidentity:UserAssignedIdentity identityName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the Resource Group to which the identity belongs.
 * @property resourceName The name of the identity resource.
 * @property tags Resource tags.
 */
public data class UserAssignedIdentityArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managedidentity.UserAssignedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.managedidentity.UserAssignedIdentityArgs =
        com.pulumi.azurenative.managedidentity.UserAssignedIdentityArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [UserAssignedIdentityArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cijgwkiinuskmiem")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Resource Group to which the identity belongs.
     */
    @JvmName("ciqleqkgusegrrlr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the identity resource.
     */
    @JvmName("phoehiwbvpkplprm")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xmkasvaagxqbsjje")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wpmdstbtwdiyhwsk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Resource Group to which the identity belongs.
     */
    @JvmName("flubhithmcyjixvb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the identity resource.
     */
    @JvmName("yiyhhhdpdwuadqjg")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("oidkvokpvayxokev")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wxbcpolsguwrvdwi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): UserAssignedIdentityArgs = UserAssignedIdentityArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
