@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managedidentity.kotlin.inputs

import com.pulumi.azurenative.managedidentity.inputs.ListUserAssignedIdentityAssociatedResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property filter OData filter expression to apply to the query.
 * @property orderby OData orderBy expression to apply to the query.
 * @property resourceGroupName The name of the Resource Group to which the identity belongs.
 * @property resourceName The name of the identity resource.
 * @property skip Number of records to skip.
 * @property skiptoken A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies a starting point to use for subsequent calls.
 * @property top Number of records to return.
 */
public data class ListUserAssignedIdentityAssociatedResourcesPlainArgs(
    public val filter: String? = null,
    public val orderby: String? = null,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val skip: Int? = null,
    public val skiptoken: String? = null,
    public val top: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managedidentity.inputs.ListUserAssignedIdentityAssociatedResourcesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managedidentity.inputs.ListUserAssignedIdentityAssociatedResourcesPlainArgs =
        com.pulumi.azurenative.managedidentity.inputs.ListUserAssignedIdentityAssociatedResourcesPlainArgs.builder()
            .filter(filter?.let({ args0 -> args0 }))
            .orderby(orderby?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .skiptoken(skiptoken?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListUserAssignedIdentityAssociatedResourcesPlainArgs].
 */
@PulumiTagMarker
public class ListUserAssignedIdentityAssociatedResourcesPlainArgsBuilder internal constructor() {
    private var filter: String? = null

    private var orderby: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var skip: Int? = null

    private var skiptoken: String? = null

    private var top: Int? = null

    /**
     * @param value OData filter expression to apply to the query.
     */
    @JvmName("yceiydctggbbsohn")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value OData orderBy expression to apply to the query.
     */
    @JvmName("dqulxadygbulrmnj")
    public suspend fun orderby(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderby = mapped
    }

    /**
     * @param value The name of the Resource Group to which the identity belongs.
     */
    @JvmName("xwhpepgyvaktxlfc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the identity resource.
     */
    @JvmName("qbnmibrpjsjuuogu")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value Number of records to skip.
     */
    @JvmName("pqkpahxpylrhdsfg")
    public suspend fun skip(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies a starting point to use for subsequent calls.
     */
    @JvmName("gawdtojmbfoqruax")
    public suspend fun skiptoken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skiptoken = mapped
    }

    /**
     * @param value Number of records to return.
     */
    @JvmName("ggthytsimqkrlmxr")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListUserAssignedIdentityAssociatedResourcesPlainArgs =
        ListUserAssignedIdentityAssociatedResourcesPlainArgs(
            filter = filter,
            orderby = orderby,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
            skip = skip,
            skiptoken = skiptoken,
            top = top,
        )
}
