@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.azurenative.managednetwork.kotlin.outputs.ConnectivityCollectionResponse
import com.pulumi.azurenative.managednetwork.kotlin.outputs.ScopeResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.managednetwork.kotlin.outputs.ConnectivityCollectionResponse.Companion.toKotlin as connectivityCollectionResponseToKotlin
import com.pulumi.azurenative.managednetwork.kotlin.outputs.ScopeResponse.Companion.toKotlin as scopeResponseToKotlin

/**
 * Builder for [ManagedNetwork].
 */
@PulumiTagMarker
public class ManagedNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedNetworkArgs = ManagedNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedNetworkArgsBuilder.() -> Unit) {
        val builder = ManagedNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.managednetwork.ManagedNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedNetwork(builtJavaResource)
    }
}

/**
 * The Managed Network resource
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### ManagedNetworksPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedNetwork = new AzureNative.ManagedNetwork.ManagedNetwork("managedNetwork", new()
 *     {
 *         Location = "eastus",
 *         ManagedNetworkName = "myManagedNetwork",
 *         ResourceGroupName = "myResourceGroup",
 *         Scope = new AzureNative.ManagedNetwork.Inputs.ScopeArgs
 *         {
 *             ManagementGroups = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/providers/Microsoft.Management/managementGroups/20000000-0001-0000-0000-000000000000",
 *                 },
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/providers/Microsoft.Management/managementGroups/20000000-0002-0000-0000-000000000000",
 *                 },
 *             },
 *             Subnets = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetA",
 *                 },
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetB",
 *                 },
 *             },
 *             Subscriptions = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "subscriptionA",
 *                 },
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "subscriptionB",
 *                 },
 *             },
 *             VirtualNetworks = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA",
 *                 },
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB",
 *                 },
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetwork.NewManagedNetwork(ctx, "managedNetwork", &managednetwork.ManagedNetworkArgs{
 * 			Location:           pulumi.String("eastus"),
 * 			ManagedNetworkName: pulumi.String("myManagedNetwork"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 			Scope: managednetwork.ScopeResponse{
 * 				ManagementGroups: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/providers/Microsoft.Management/managementGroups/20000000-0001-0000-0000-000000000000"),
 * 					},
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/providers/Microsoft.Management/managementGroups/20000000-0002-0000-0000-000000000000"),
 * 					},
 * 				},
 * 				Subnets: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetA"),
 * 					},
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetB"),
 * 					},
 * 				},
 * 				Subscriptions: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("subscriptionA"),
 * 					},
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("subscriptionB"),
 * 					},
 * 				},
 * 				VirtualNetworks: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
 * 					},
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"),
 * 					},
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetwork.ManagedNetwork;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedNetwork = new ManagedNetwork("managedNetwork", ManagedNetworkArgs.builder()
 *             .location("eastus")
 *             .managedNetworkName("myManagedNetwork")
 *             .resourceGroupName("myResourceGroup")
 *             .scope(Map.ofEntries(
 *                 Map.entry("managementGroups",
 *                     Map.of("id", "/providers/Microsoft.Management/managementGroups/20000000-0001-0000-0000-000000000000"),
 *                     Map.of("id", "/providers/Microsoft.Management/managementGroups/20000000-0002-0000-0000-000000000000")),
 *                 Map.entry("subnets",
 *                     Map.of("id", "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetA"),
 *                     Map.of("id", "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetB")),
 *                 Map.entry("subscriptions",
 *                     Map.of("id", "subscriptionA"),
 *                     Map.of("id", "subscriptionB")),
 *                 Map.entry("virtualNetworks",
 *                     Map.of("id", "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
 *                     Map.of("id", "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"))
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetwork:ManagedNetwork myManagedNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}
 * ```
 */
public class ManagedNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetwork.ManagedNetwork,
) : KotlinCustomResource(javaResource, ManagedNetworkMapper) {
    /**
     * The collection of groups and policies concerned with connectivity
     */
    public val connectivity: Output<ConnectivityCollectionResponse>
        get() = javaResource.connectivity().applyValue({ args0 ->
            args0.let({ args0 ->
                connectivityCollectionResponseToKotlin(args0)
            })
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the ManagedNetwork resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The collection of management groups, subscriptions, virtual networks, and subnets by the Managed Network. This is a read-only property that is reflective of all ScopeAssignments for this Managed Network
     */
    public val scope: Output<ScopeResponse>?
        get() = javaResource.scope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    scopeResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedNetworkMapper : ResourceMapper<ManagedNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetwork.ManagedNetwork::class == javaResource::class

    override fun map(javaResource: Resource): ManagedNetwork = ManagedNetwork(
        javaResource as
            com.pulumi.azurenative.managednetwork.ManagedNetwork,
    )
}

/**
 * @see [ManagedNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedNetwork].
 */
public suspend fun managedNetwork(
    name: String,
    block: suspend ManagedNetworkResourceBuilder.() -> Unit,
): ManagedNetwork {
    val builder = ManagedNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedNetwork(name: String): ManagedNetwork {
    val builder = ManagedNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
