@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.azurenative.managednetwork.ManagedNetworkArgs.builder
import com.pulumi.azurenative.managednetwork.kotlin.inputs.ScopeArgs
import com.pulumi.azurenative.managednetwork.kotlin.inputs.ScopeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The Managed Network resource
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### ManagedNetworksPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedNetwork = new AzureNative.ManagedNetwork.ManagedNetwork("managedNetwork", new()
 *     {
 *         Location = "eastus",
 *         ManagedNetworkName = "myManagedNetwork",
 *         ResourceGroupName = "myResourceGroup",
 *         Scope = new AzureNative.ManagedNetwork.Inputs.ScopeArgs
 *         {
 *             ManagementGroups = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/providers/Microsoft.Management/managementGroups/20000000-0001-0000-0000-000000000000",
 *                 },
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/providers/Microsoft.Management/managementGroups/20000000-0002-0000-0000-000000000000",
 *                 },
 *             },
 *             Subnets = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetA",
 *                 },
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetB",
 *                 },
 *             },
 *             Subscriptions = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "subscriptionA",
 *                 },
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "subscriptionB",
 *                 },
 *             },
 *             VirtualNetworks = new[]
 *             {
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA",
 *                 },
 *                 new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB",
 *                 },
 *             },
 *         },
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetwork.NewManagedNetwork(ctx, "managedNetwork", &managednetwork.ManagedNetworkArgs{
 * 			Location:           pulumi.String("eastus"),
 * 			ManagedNetworkName: pulumi.String("myManagedNetwork"),
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 			Scope: managednetwork.ScopeResponse{
 * 				ManagementGroups: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/providers/Microsoft.Management/managementGroups/20000000-0001-0000-0000-000000000000"),
 * 					},
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/providers/Microsoft.Management/managementGroups/20000000-0002-0000-0000-000000000000"),
 * 					},
 * 				},
 * 				Subnets: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetA"),
 * 					},
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetB"),
 * 					},
 * 				},
 * 				Subscriptions: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("subscriptionA"),
 * 					},
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("subscriptionB"),
 * 					},
 * 				},
 * 				VirtualNetworks: managednetwork.ResourceIdArray{
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
 * 					},
 * 					&managednetwork.ResourceIdArgs{
 * 						Id: pulumi.String("/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"),
 * 					},
 * 				},
 * 			},
 * 			Tags: nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetwork.ManagedNetwork;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedNetwork = new ManagedNetwork("managedNetwork", ManagedNetworkArgs.builder()
 *             .location("eastus")
 *             .managedNetworkName("myManagedNetwork")
 *             .resourceGroupName("myResourceGroup")
 *             .scope(Map.ofEntries(
 *                 Map.entry("managementGroups",
 *                     Map.of("id", "/providers/Microsoft.Management/managementGroups/20000000-0001-0000-0000-000000000000"),
 *                     Map.of("id", "/providers/Microsoft.Management/managementGroups/20000000-0002-0000-0000-000000000000")),
 *                 Map.entry("subnets",
 *                     Map.of("id", "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetA"),
 *                     Map.of("id", "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetC/subnets/subnetB")),
 *                 Map.entry("subscriptions",
 *                     Map.of("id", "subscriptionA"),
 *                     Map.of("id", "subscriptionB")),
 *                 Map.entry("virtualNetworks",
 *                     Map.of("id", "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
 *                     Map.of("id", "/subscriptions/subscriptionC/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"))
 *             ))
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetwork:ManagedNetwork myManagedNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}
 * ```
 * @property location The geo-location where the resource lives
 * @property managedNetworkName The name of the Managed Network.
 * @property resourceGroupName The name of the resource group.
 * @property scope The collection of management groups, subscriptions, virtual networks, and subnets by the Managed Network. This is a read-only property that is reflective of all ScopeAssignments for this Managed Network
 * @property tags Resource tags
 */
public data class ManagedNetworkArgs(
    public val location: Output<String>? = null,
    public val managedNetworkName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scope: Output<ScopeArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.ManagedNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetwork.ManagedNetworkArgs =
        com.pulumi.azurenative.managednetwork.ManagedNetworkArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .managedNetworkName(managedNetworkName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedNetworkArgs].
 */
@PulumiTagMarker
public class ManagedNetworkArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var managedNetworkName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scope: Output<ScopeArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lmifpsvwybndsdyq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("gcpxssrusehfhetc")
    public suspend fun managedNetworkName(`value`: Output<String>) {
        this.managedNetworkName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cktkaamsaqcptalc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The collection of management groups, subscriptions, virtual networks, and subnets by the Managed Network. This is a read-only property that is reflective of all ScopeAssignments for this Managed Network
     */
    @JvmName("hsgsgrtfdnskknwr")
    public suspend fun scope(`value`: Output<ScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("bmdijuocpsceioqw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mmgtkpgndbrbpbbi")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("pieohlmbjogobkef")
    public suspend fun managedNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedNetworkName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xcivsjnqbilpnhar")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The collection of management groups, subscriptions, virtual networks, and subnets by the Managed Network. This is a read-only property that is reflective of all ScopeAssignments for this Managed Network
     */
    @JvmName("ktvoduamivqlldwd")
    public suspend fun scope(`value`: ScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument The collection of management groups, subscriptions, virtual networks, and subnets by the Managed Network. This is a read-only property that is reflective of all ScopeAssignments for this Managed Network
     */
    @JvmName("epoextksgiykxvaf")
    public suspend fun scope(argument: suspend ScopeArgsBuilder.() -> Unit) {
        val toBeMapped = ScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("ibpmiubqjemsnjuf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("wmokxxyjblupdhuj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedNetworkArgs = ManagedNetworkArgs(
        location = location,
        managedNetworkName = managedNetworkName,
        resourceGroupName = resourceGroupName,
        scope = scope,
        tags = tags,
    )
}
