@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.azurenative.managednetwork.ManagedNetworkGroupArgs.builder
import com.pulumi.azurenative.managednetwork.kotlin.enums.Kind
import com.pulumi.azurenative.managednetwork.kotlin.inputs.ResourceIdArgs
import com.pulumi.azurenative.managednetwork.kotlin.inputs.ResourceIdArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Managed Network Group resource
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### ManagementNetworkGroupsPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedNetworkGroup = new AzureNative.ManagedNetwork.ManagedNetworkGroup("managedNetworkGroup", new()
 *     {
 *         ManagedNetworkGroupName = "myManagedNetworkGroup1",
 *         ManagedNetworkName = "myManagedNetwork",
 *         ManagementGroups = new[] {},
 *         ResourceGroupName = "myResourceGroup",
 *         Subnets = new[]
 *         {
 *             new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *             {
 *                 Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA/subnets/subnetA",
 *             },
 *         },
 *         Subscriptions = new[] {},
 *         VirtualNetworks = new[]
 *         {
 *             new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *             {
 *                 Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA",
 *             },
 *             new AzureNative.ManagedNetwork.Inputs.ResourceIdArgs
 *             {
 *                 Id = "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetwork.NewManagedNetworkGroup(ctx, "managedNetworkGroup", &managednetwork.ManagedNetworkGroupArgs{
 * 			ManagedNetworkGroupName: pulumi.String("myManagedNetworkGroup1"),
 * 			ManagedNetworkName:      pulumi.String("myManagedNetwork"),
 * 			ManagementGroups:        managednetwork.ResourceIdArray{},
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 			Subnets: []managednetwork.ResourceIdArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA/subnets/subnetA"),
 * 				},
 * 			},
 * 			Subscriptions: managednetwork.ResourceIdArray{},
 * 			VirtualNetworks: []managednetwork.ResourceIdArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
 * 				},
 * 				{
 * 					Id: pulumi.String("/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkGroup;
 * import com.pulumi.azurenative.managednetwork.ManagedNetworkGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedNetworkGroup = new ManagedNetworkGroup("managedNetworkGroup", ManagedNetworkGroupArgs.builder()
 *             .managedNetworkGroupName("myManagedNetworkGroup1")
 *             .managedNetworkName("myManagedNetwork")
 *             .managementGroups()
 *             .resourceGroupName("myResourceGroup")
 *             .subnets(Map.of("id", "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA/subnets/subnetA"))
 *             .subscriptions()
 *             .virtualNetworks(
 *                 Map.of("id", "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetA"),
 *                 Map.of("id", "/subscriptionB/resourceGroups/myResourceGroup/providers/Microsoft.Network/virtualNetworks/VnetB"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetwork:ManagedNetworkGroup myManagedNetworkGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetwork/managedNetworks/{managedNetworkName}/managedNetworkGroups/{managedNetworkGroupName}
 * ```
 * @property kind Responsibility role under which this Managed Network Group will be created
 * @property location The geo-location where the resource lives
 * @property managedNetworkGroupName The name of the Managed Network Group.
 * @property managedNetworkName The name of the Managed Network.
 * @property managementGroups The collection of management groups covered by the Managed Network
 * @property resourceGroupName The name of the resource group.
 * @property subnets The collection of  subnets covered by the Managed Network
 * @property subscriptions The collection of subscriptions covered by the Managed Network
 * @property virtualNetworks The collection of virtual nets covered by the Managed Network
 */
public data class ManagedNetworkGroupArgs(
    public val kind: Output<Either<String, Kind>>? = null,
    public val location: Output<String>? = null,
    public val managedNetworkGroupName: Output<String>? = null,
    public val managedNetworkName: Output<String>? = null,
    public val managementGroups: Output<List<ResourceIdArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnets: Output<List<ResourceIdArgs>>? = null,
    public val subscriptions: Output<List<ResourceIdArgs>>? = null,
    public val virtualNetworks: Output<List<ResourceIdArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.ManagedNetworkGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetwork.ManagedNetworkGroupArgs =
        com.pulumi.azurenative.managednetwork.ManagedNetworkGroupArgs.builder()
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .managedNetworkGroupName(managedNetworkGroupName?.applyValue({ args0 -> args0 }))
            .managedNetworkName(managedNetworkName?.applyValue({ args0 -> args0 }))
            .managementGroups(
                managementGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subscriptions(
                subscriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworks(
                virtualNetworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedNetworkGroupArgs].
 */
@PulumiTagMarker
public class ManagedNetworkGroupArgsBuilder internal constructor() {
    private var kind: Output<Either<String, Kind>>? = null

    private var location: Output<String>? = null

    private var managedNetworkGroupName: Output<String>? = null

    private var managedNetworkName: Output<String>? = null

    private var managementGroups: Output<List<ResourceIdArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnets: Output<List<ResourceIdArgs>>? = null

    private var subscriptions: Output<List<ResourceIdArgs>>? = null

    private var virtualNetworks: Output<List<ResourceIdArgs>>? = null

    /**
     * @param value Responsibility role under which this Managed Network Group will be created
     */
    @JvmName("wvvwoheyevwrmhfg")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("drnppdnwocbjrtht")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Managed Network Group.
     */
    @JvmName("evqasvkwkifgxhen")
    public suspend fun managedNetworkGroupName(`value`: Output<String>) {
        this.managedNetworkGroupName = value
    }

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("mdcicdtghfhjisjf")
    public suspend fun managedNetworkName(`value`: Output<String>) {
        this.managedNetworkName = value
    }

    /**
     * @param value The collection of management groups covered by the Managed Network
     */
    @JvmName("wyubywjpcfmvsweh")
    public suspend fun managementGroups(`value`: Output<List<ResourceIdArgs>>) {
        this.managementGroups = value
    }

    @JvmName("oexlaodjncyrebcj")
    public suspend fun managementGroups(vararg values: Output<ResourceIdArgs>) {
        this.managementGroups = Output.all(values.asList())
    }

    /**
     * @param values The collection of management groups covered by the Managed Network
     */
    @JvmName("tbrmjyuwbayqcjqm")
    public suspend fun managementGroups(values: List<Output<ResourceIdArgs>>) {
        this.managementGroups = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("lvbflnkmgikiulhp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The collection of  subnets covered by the Managed Network
     */
    @JvmName("axppactdimnnwvsc")
    public suspend fun subnets(`value`: Output<List<ResourceIdArgs>>) {
        this.subnets = value
    }

    @JvmName("qodiittuaqyqugei")
    public suspend fun subnets(vararg values: Output<ResourceIdArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The collection of  subnets covered by the Managed Network
     */
    @JvmName("uaauitesrodxrnkk")
    public suspend fun subnets(values: List<Output<ResourceIdArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value The collection of subscriptions covered by the Managed Network
     */
    @JvmName("pjgpmipbmokepgth")
    public suspend fun subscriptions(`value`: Output<List<ResourceIdArgs>>) {
        this.subscriptions = value
    }

    @JvmName("dvptkxsprkcltaay")
    public suspend fun subscriptions(vararg values: Output<ResourceIdArgs>) {
        this.subscriptions = Output.all(values.asList())
    }

    /**
     * @param values The collection of subscriptions covered by the Managed Network
     */
    @JvmName("xvdjkvkowgevdutd")
    public suspend fun subscriptions(values: List<Output<ResourceIdArgs>>) {
        this.subscriptions = Output.all(values)
    }

    /**
     * @param value The collection of virtual nets covered by the Managed Network
     */
    @JvmName("bmlijvigouxolsxw")
    public suspend fun virtualNetworks(`value`: Output<List<ResourceIdArgs>>) {
        this.virtualNetworks = value
    }

    @JvmName("vphhqiosvxraohwt")
    public suspend fun virtualNetworks(vararg values: Output<ResourceIdArgs>) {
        this.virtualNetworks = Output.all(values.asList())
    }

    /**
     * @param values The collection of virtual nets covered by the Managed Network
     */
    @JvmName("dryllsfsdweercea")
    public suspend fun virtualNetworks(values: List<Output<ResourceIdArgs>>) {
        this.virtualNetworks = Output.all(values)
    }

    /**
     * @param value Responsibility role under which this Managed Network Group will be created
     */
    @JvmName("fhbwbkxksoncyjxl")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Responsibility role under which this Managed Network Group will be created
     */
    @JvmName("dwlvuwwiesbdhjaw")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Responsibility role under which this Managed Network Group will be created
     */
    @JvmName("unftfraowtdauilq")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pnymwysqcuxpjvvq")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Managed Network Group.
     */
    @JvmName("yislvamtbwrarxdq")
    public suspend fun managedNetworkGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedNetworkGroupName = mapped
    }

    /**
     * @param value The name of the Managed Network.
     */
    @JvmName("xflvitvwfkpbtnhi")
    public suspend fun managedNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedNetworkName = mapped
    }

    /**
     * @param value The collection of management groups covered by the Managed Network
     */
    @JvmName("bmeaekimeiqrggvl")
    public suspend fun managementGroups(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param argument The collection of management groups covered by the Managed Network
     */
    @JvmName("lgxxlcasijnijrfb")
    public suspend fun managementGroups(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.managementGroups = mapped
    }

    /**
     * @param argument The collection of management groups covered by the Managed Network
     */
    @JvmName("vbmfkmlbgtusksqs")
    public suspend fun managementGroups(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.managementGroups = mapped
    }

    /**
     * @param argument The collection of management groups covered by the Managed Network
     */
    @JvmName("ekmvqxpshmxumswc")
    public suspend fun managementGroups(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.managementGroups = mapped
    }

    /**
     * @param values The collection of management groups covered by the Managed Network
     */
    @JvmName("eyhguscwbkohlqny")
    public suspend fun managementGroups(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managementGroups = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vydeogjufctgysyk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The collection of  subnets covered by the Managed Network
     */
    @JvmName("dyqbbqfmackexmti")
    public suspend fun subnets(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument The collection of  subnets covered by the Managed Network
     */
    @JvmName("orlservfedyklpfj")
    public suspend fun subnets(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The collection of  subnets covered by the Managed Network
     */
    @JvmName("ljvkrrjnghamaegx")
    public suspend fun subnets(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument The collection of  subnets covered by the Managed Network
     */
    @JvmName("jcvnlcvanqxcdbkk")
    public suspend fun subnets(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values The collection of  subnets covered by the Managed Network
     */
    @JvmName("wgrpmxtffndwcwcg")
    public suspend fun subnets(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value The collection of subscriptions covered by the Managed Network
     */
    @JvmName("xgihqgomesfakbxo")
    public suspend fun subscriptions(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param argument The collection of subscriptions covered by the Managed Network
     */
    @JvmName("atakyxttjpfynakr")
    public suspend fun subscriptions(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param argument The collection of subscriptions covered by the Managed Network
     */
    @JvmName("qjcrvlspwkaekuru")
    public suspend fun subscriptions(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param argument The collection of subscriptions covered by the Managed Network
     */
    @JvmName("eohvgafmyfrqgmeu")
    public suspend fun subscriptions(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subscriptions = mapped
    }

    /**
     * @param values The collection of subscriptions covered by the Managed Network
     */
    @JvmName("euqlfwcanbhgovxr")
    public suspend fun subscriptions(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscriptions = mapped
    }

    /**
     * @param value The collection of virtual nets covered by the Managed Network
     */
    @JvmName("rlqymvgdfvrxtksw")
    public suspend fun virtualNetworks(`value`: List<ResourceIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworks = mapped
    }

    /**
     * @param argument The collection of virtual nets covered by the Managed Network
     */
    @JvmName("eoqnxnswxwggwuhi")
    public suspend fun virtualNetworks(argument: List<suspend ResourceIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.virtualNetworks = mapped
    }

    /**
     * @param argument The collection of virtual nets covered by the Managed Network
     */
    @JvmName("nxvmofsbttbhkmqj")
    public suspend fun virtualNetworks(vararg argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ResourceIdArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.virtualNetworks = mapped
    }

    /**
     * @param argument The collection of virtual nets covered by the Managed Network
     */
    @JvmName("tatwbrxfqrlbogau")
    public suspend fun virtualNetworks(argument: suspend ResourceIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworks = mapped
    }

    /**
     * @param values The collection of virtual nets covered by the Managed Network
     */
    @JvmName("lriaakcpmyspehoq")
    public suspend fun virtualNetworks(vararg values: ResourceIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworks = mapped
    }

    internal fun build(): ManagedNetworkGroupArgs = ManagedNetworkGroupArgs(
        kind = kind,
        location = location,
        managedNetworkGroupName = managedNetworkGroupName,
        managedNetworkName = managedNetworkName,
        managementGroups = managementGroups,
        resourceGroupName = resourceGroupName,
        subnets = subnets,
        subscriptions = subscriptions,
        virtualNetworks = virtualNetworks,
    )
}
