@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.azurenative.managednetwork.ManagednetworkFunctions.getManagedNetworkGroupPlain
import com.pulumi.azurenative.managednetwork.ManagednetworkFunctions.getManagedNetworkPeeringPolicyPlain
import com.pulumi.azurenative.managednetwork.ManagednetworkFunctions.getManagedNetworkPlain
import com.pulumi.azurenative.managednetwork.ManagednetworkFunctions.getScopeAssignmentPlain
import com.pulumi.azurenative.managednetwork.kotlin.inputs.GetManagedNetworkGroupPlainArgs
import com.pulumi.azurenative.managednetwork.kotlin.inputs.GetManagedNetworkGroupPlainArgsBuilder
import com.pulumi.azurenative.managednetwork.kotlin.inputs.GetManagedNetworkPeeringPolicyPlainArgs
import com.pulumi.azurenative.managednetwork.kotlin.inputs.GetManagedNetworkPeeringPolicyPlainArgsBuilder
import com.pulumi.azurenative.managednetwork.kotlin.inputs.GetManagedNetworkPlainArgs
import com.pulumi.azurenative.managednetwork.kotlin.inputs.GetManagedNetworkPlainArgsBuilder
import com.pulumi.azurenative.managednetwork.kotlin.inputs.GetScopeAssignmentPlainArgs
import com.pulumi.azurenative.managednetwork.kotlin.inputs.GetScopeAssignmentPlainArgsBuilder
import com.pulumi.azurenative.managednetwork.kotlin.outputs.GetManagedNetworkGroupResult
import com.pulumi.azurenative.managednetwork.kotlin.outputs.GetManagedNetworkPeeringPolicyResult
import com.pulumi.azurenative.managednetwork.kotlin.outputs.GetManagedNetworkResult
import com.pulumi.azurenative.managednetwork.kotlin.outputs.GetScopeAssignmentResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.managednetwork.kotlin.outputs.GetManagedNetworkGroupResult.Companion.toKotlin as getManagedNetworkGroupResultToKotlin
import com.pulumi.azurenative.managednetwork.kotlin.outputs.GetManagedNetworkPeeringPolicyResult.Companion.toKotlin as getManagedNetworkPeeringPolicyResultToKotlin
import com.pulumi.azurenative.managednetwork.kotlin.outputs.GetManagedNetworkResult.Companion.toKotlin as getManagedNetworkResultToKotlin
import com.pulumi.azurenative.managednetwork.kotlin.outputs.GetScopeAssignmentResult.Companion.toKotlin as getScopeAssignmentResultToKotlin

public object ManagednetworkFunctions {
    /**
     * The Get ManagedNetworks operation gets a Managed Network Resource, specified by the resource group and Managed Network name
     * Azure REST API version: 2019-06-01-preview.
     * @param argument null
     * @return The Managed Network resource
     */
    public suspend fun getManagedNetwork(argument: GetManagedNetworkPlainArgs):
        GetManagedNetworkResult =
        getManagedNetworkResultToKotlin(getManagedNetworkPlain(argument.toJava()).await())

    /**
     * @see [getManagedNetwork].
     * @param managedNetworkName The name of the Managed Network.
     * @param resourceGroupName The name of the resource group.
     * @return The Managed Network resource
     */
    public suspend fun getManagedNetwork(managedNetworkName: String, resourceGroupName: String):
        GetManagedNetworkResult {
        val argument = GetManagedNetworkPlainArgs(
            managedNetworkName = managedNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedNetworkResultToKotlin(getManagedNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetwork&#46;kotlin&#46;inputs&#46;GetManagedNetworkPlainArgs].
     * @return The Managed Network resource
     */
    public suspend
    fun getManagedNetwork(argument: suspend GetManagedNetworkPlainArgsBuilder.() -> Unit):
        GetManagedNetworkResult {
        val builder = GetManagedNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedNetworkResultToKotlin(getManagedNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * The Get ManagedNetworkGroups operation gets a Managed Network Group specified by the resource group, Managed Network name, and group name
     * Azure REST API version: 2019-06-01-preview.
     * @param argument null
     * @return The Managed Network Group resource
     */
    public suspend fun getManagedNetworkGroup(argument: GetManagedNetworkGroupPlainArgs):
        GetManagedNetworkGroupResult =
        getManagedNetworkGroupResultToKotlin(getManagedNetworkGroupPlain(argument.toJava()).await())

    /**
     * @see [getManagedNetworkGroup].
     * @param managedNetworkGroupName The name of the Managed Network Group.
     * @param managedNetworkName The name of the Managed Network.
     * @param resourceGroupName The name of the resource group.
     * @return The Managed Network Group resource
     */
    public suspend fun getManagedNetworkGroup(
        managedNetworkGroupName: String,
        managedNetworkName: String,
        resourceGroupName: String,
    ): GetManagedNetworkGroupResult {
        val argument = GetManagedNetworkGroupPlainArgs(
            managedNetworkGroupName = managedNetworkGroupName,
            managedNetworkName = managedNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedNetworkGroupResultToKotlin(getManagedNetworkGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedNetworkGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetwork&#46;kotlin&#46;inputs&#46;GetManagedNetworkGroupPlainArgs].
     * @return The Managed Network Group resource
     */
    public suspend
    fun getManagedNetworkGroup(argument: suspend GetManagedNetworkGroupPlainArgsBuilder.() -> Unit):
        GetManagedNetworkGroupResult {
        val builder = GetManagedNetworkGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedNetworkGroupResultToKotlin(getManagedNetworkGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * The Get ManagedNetworkPeeringPolicies operation gets a Managed Network Peering Policy resource, specified by the  resource group, Managed Network name, and peering policy name
     * Azure REST API version: 2019-06-01-preview.
     * @param argument null
     * @return The Managed Network Peering Policy resource
     */
    public suspend
    fun getManagedNetworkPeeringPolicy(argument: GetManagedNetworkPeeringPolicyPlainArgs):
        GetManagedNetworkPeeringPolicyResult =
        getManagedNetworkPeeringPolicyResultToKotlin(getManagedNetworkPeeringPolicyPlain(argument.toJava()).await())

    /**
     * @see [getManagedNetworkPeeringPolicy].
     * @param managedNetworkName The name of the Managed Network.
     * @param managedNetworkPeeringPolicyName The name of the Managed Network Peering Policy.
     * @param resourceGroupName The name of the resource group.
     * @return The Managed Network Peering Policy resource
     */
    public suspend fun getManagedNetworkPeeringPolicy(
        managedNetworkName: String,
        managedNetworkPeeringPolicyName: String,
        resourceGroupName: String,
    ): GetManagedNetworkPeeringPolicyResult {
        val argument = GetManagedNetworkPeeringPolicyPlainArgs(
            managedNetworkName = managedNetworkName,
            managedNetworkPeeringPolicyName = managedNetworkPeeringPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedNetworkPeeringPolicyResultToKotlin(getManagedNetworkPeeringPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedNetworkPeeringPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetwork&#46;kotlin&#46;inputs&#46;GetManagedNetworkPeeringPolicyPlainArgs].
     * @return The Managed Network Peering Policy resource
     */
    public suspend
    fun getManagedNetworkPeeringPolicy(argument: suspend GetManagedNetworkPeeringPolicyPlainArgsBuilder.() -> Unit):
        GetManagedNetworkPeeringPolicyResult {
        val builder = GetManagedNetworkPeeringPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedNetworkPeeringPolicyResultToKotlin(getManagedNetworkPeeringPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the specified scope assignment.
     * Azure REST API version: 2019-06-01-preview.
     * @param argument null
     * @return The Managed Network resource
     */
    public suspend fun getScopeAssignment(argument: GetScopeAssignmentPlainArgs):
        GetScopeAssignmentResult =
        getScopeAssignmentResultToKotlin(getScopeAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getScopeAssignment].
     * @param scope The base resource of the scope assignment.
     * @param scopeAssignmentName The name of the scope assignment to get.
     * @return The Managed Network resource
     */
    public suspend fun getScopeAssignment(scope: String, scopeAssignmentName: String):
        GetScopeAssignmentResult {
        val argument = GetScopeAssignmentPlainArgs(
            scope = scope,
            scopeAssignmentName = scopeAssignmentName,
        )
        return getScopeAssignmentResultToKotlin(getScopeAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getScopeAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;managednetwork&#46;kotlin&#46;inputs&#46;GetScopeAssignmentPlainArgs].
     * @return The Managed Network resource
     */
    public suspend
    fun getScopeAssignment(argument: suspend GetScopeAssignmentPlainArgsBuilder.() -> Unit):
        GetScopeAssignmentResult {
        val builder = GetScopeAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScopeAssignmentResultToKotlin(getScopeAssignmentPlain(builtArgument.toJava()).await())
    }
}
