@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin

import com.pulumi.azurenative.managednetwork.ScopeAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Managed Network resource
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### ScopeAssignmentsPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopeAssignment = new AzureNative.ManagedNetwork.ScopeAssignment("scopeAssignment", new()
 *     {
 *         AssignedManagedNetwork = "/subscriptions/subscriptionA/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork",
 *         Scope = "subscriptions/subscriptionC",
 *         ScopeAssignmentName = "subscriptionCAssignment",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetwork.NewScopeAssignment(ctx, "scopeAssignment", &managednetwork.ScopeAssignmentArgs{
 * 			AssignedManagedNetwork: pulumi.String("/subscriptions/subscriptionA/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork"),
 * 			Scope:                  pulumi.String("subscriptions/subscriptionC"),
 * 			ScopeAssignmentName:    pulumi.String("subscriptionCAssignment"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetwork.ScopeAssignment;
 * import com.pulumi.azurenative.managednetwork.ScopeAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopeAssignment = new ScopeAssignment("scopeAssignment", ScopeAssignmentArgs.builder()
 *             .assignedManagedNetwork("/subscriptions/subscriptionA/resourceGroups/myResourceGroup/providers/Microsoft.ManagedNetwork/managedNetworks/myManagedNetwork")
 *             .scope("subscriptions/subscriptionC")
 *             .scopeAssignmentName("subscriptionCAssignment")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetwork:ScopeAssignment subscriptionCAssignment /{scope}/providers/Microsoft.ManagedNetwork/scopeAssignments/{scopeAssignmentName}
 * ```
 * @property assignedManagedNetwork The managed network ID with scope will be assigned to.
 * @property location The geo-location where the resource lives
 * @property scope The base resource of the scope assignment to create. The scope can be any REST resource instance. For example, use 'subscriptions/{subscription-id}' for a subscription, 'subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and 'subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
 * @property scopeAssignmentName The name of the scope assignment to create.
 */
public data class ScopeAssignmentArgs(
    public val assignedManagedNetwork: Output<String>? = null,
    public val location: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val scopeAssignmentName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.ScopeAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetwork.ScopeAssignmentArgs =
        com.pulumi.azurenative.managednetwork.ScopeAssignmentArgs.builder()
            .assignedManagedNetwork(assignedManagedNetwork?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .scopeAssignmentName(scopeAssignmentName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopeAssignmentArgs].
 */
@PulumiTagMarker
public class ScopeAssignmentArgsBuilder internal constructor() {
    private var assignedManagedNetwork: Output<String>? = null

    private var location: Output<String>? = null

    private var scope: Output<String>? = null

    private var scopeAssignmentName: Output<String>? = null

    /**
     * @param value The managed network ID with scope will be assigned to.
     */
    @JvmName("dfgkxbspitcgnhhw")
    public suspend fun assignedManagedNetwork(`value`: Output<String>) {
        this.assignedManagedNetwork = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ygvqftchssuliomr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The base resource of the scope assignment to create. The scope can be any REST resource instance. For example, use 'subscriptions/{subscription-id}' for a subscription, 'subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and 'subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     */
    @JvmName("xijwqdxfmgooxgls")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The name of the scope assignment to create.
     */
    @JvmName("nrrmtrpcmfbhiwpd")
    public suspend fun scopeAssignmentName(`value`: Output<String>) {
        this.scopeAssignmentName = value
    }

    /**
     * @param value The managed network ID with scope will be assigned to.
     */
    @JvmName("ectbihuadwarcdkf")
    public suspend fun assignedManagedNetwork(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignedManagedNetwork = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gduddvhxmhhbbkmg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The base resource of the scope assignment to create. The scope can be any REST resource instance. For example, use 'subscriptions/{subscription-id}' for a subscription, 'subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and 'subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}' for a resource.
     */
    @JvmName("mgrnwqdorukpfvpk")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The name of the scope assignment to create.
     */
    @JvmName("igramyuaehsbycdq")
    public suspend fun scopeAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeAssignmentName = mapped
    }

    internal fun build(): ScopeAssignmentArgs = ScopeAssignmentArgs(
        assignedManagedNetwork = assignedManagedNetwork,
        location = location,
        scope = scope,
        scopeAssignmentName = scopeAssignmentName,
    )
}
