@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the connectivity type of a network structure policy
 */
public enum class Type(
    public val javaValue: com.pulumi.azurenative.managednetwork.enums.Type,
) : ConvertibleToJava<com.pulumi.azurenative.managednetwork.enums.Type> {
    HubAndSpokeTopology(com.pulumi.azurenative.managednetwork.enums.Type.HubAndSpokeTopology),
    MeshTopology(com.pulumi.azurenative.managednetwork.enums.Type.MeshTopology),
    ;

    override fun toJava(): com.pulumi.azurenative.managednetwork.enums.Type = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.managednetwork.enums.Type): Type =
            Type.values().first { it.javaValue == javaType }
    }
}
