@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.RulePropertiesResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.RulePropertiesResponse.Companion.toKotlin as rulePropertiesResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [InternetGatewayRule].
 */
@PulumiTagMarker
public class InternetGatewayRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InternetGatewayRuleArgs = InternetGatewayRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InternetGatewayRuleArgsBuilder.() -> Unit) {
        val builder = InternetGatewayRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InternetGatewayRule {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.InternetGatewayRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InternetGatewayRule(builtJavaResource)
    }
}

/**
 * The Internet Gateway Rule resource definition.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### InternetGatewayRules_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var internetGatewayRule = new AzureNative.ManagedNetworkFabric.InternetGatewayRule("internetGatewayRule", new()
 *     {
 *         Annotation = "annotationValue",
 *         InternetGatewayRuleName = "example-internetGatewayRule",
 *         Location = "eastus",
 *         ResourceGroupName = "example-rg",
 *         RuleProperties = new AzureNative.ManagedNetworkFabric.Inputs.RulePropertiesArgs
 *         {
 *             Action = "Allow",
 *             AddressList = new[]
 *             {
 *                 "10.10.10.10",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "keyID", "keyValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewInternetGatewayRule(ctx, "internetGatewayRule", &managednetworkfabric.InternetGatewayRuleArgs{
 * 			Annotation:              pulumi.String("annotationValue"),
 * 			InternetGatewayRuleName: pulumi.String("example-internetGatewayRule"),
 * 			Location:                pulumi.String("eastus"),
 * 			ResourceGroupName:       pulumi.String("example-rg"),
 * 			RuleProperties: &managednetworkfabric.RulePropertiesArgs{
 * 				Action: pulumi.String("Allow"),
 * 				AddressList: pulumi.StringArray{
 * 					pulumi.String("10.10.10.10"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"keyID": pulumi.String("keyValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.InternetGatewayRule;
 * import com.pulumi.azurenative.managednetworkfabric.InternetGatewayRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var internetGatewayRule = new InternetGatewayRule("internetGatewayRule", InternetGatewayRuleArgs.builder()
 *             .annotation("annotationValue")
 *             .internetGatewayRuleName("example-internetGatewayRule")
 *             .location("eastus")
 *             .resourceGroupName("example-rg")
 *             .ruleProperties(Map.ofEntries(
 *                 Map.entry("action", "Allow"),
 *                 Map.entry("addressList", "10.10.10.10")
 *             ))
 *             .tags(Map.of("keyID", "keyValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:InternetGatewayRule example-internetGatewayRule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/internetGatewayRules/{internetGatewayRuleName}
 * ```
 */
public class InternetGatewayRule internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.InternetGatewayRule,
) : KotlinCustomResource(javaResource, InternetGatewayRuleMapper) {
    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of Internet Gateway resource Id.
     */
    public val internetGatewayIds: Output<List<String>>
        get() = javaResource.internetGatewayIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Rules for the InternetGateways
     */
    public val ruleProperties: Output<RulePropertiesResponse>
        get() = javaResource.ruleProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                rulePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InternetGatewayRuleMapper : ResourceMapper<InternetGatewayRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.InternetGatewayRule::class == javaResource::class

    override fun map(javaResource: Resource): InternetGatewayRule = InternetGatewayRule(
        javaResource
            as com.pulumi.azurenative.managednetworkfabric.InternetGatewayRule,
    )
}

/**
 * @see [InternetGatewayRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InternetGatewayRule].
 */
public suspend fun internetGatewayRule(
    name: String,
    block: suspend InternetGatewayRuleResourceBuilder.() -> Unit,
): InternetGatewayRule {
    val builder = InternetGatewayRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InternetGatewayRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun internetGatewayRule(name: String): InternetGatewayRule {
    val builder = InternetGatewayRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
