@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.L3IsolationDomainArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.RedistributeConnectedSubnets
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.RedistributeStaticRoutes
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.AggregateRouteConfigurationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.AggregateRouteConfigurationArgsBuilder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The L3IsolationDomain resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### L3IsolationDomains_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var l3IsolationDomain = new AzureNative.ManagedNetworkFabric.L3IsolationDomain("l3IsolationDomain", new()
 *     {
 *         AggregateRouteConfiguration = new AzureNative.ManagedNetworkFabric.Inputs.AggregateRouteConfigurationArgs
 *         {
 *             Ipv4Routes = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.AggregateRouteArgs
 *                 {
 *                     Prefix = "10.0.0.0/24",
 *                 },
 *             },
 *             Ipv6Routes = new[]
 *             {
 *                 new AzureNative.ManagedNetworkFabric.Inputs.AggregateRouteArgs
 *                 {
 *                     Prefix = "10.0.0.1",
 *                 },
 *             },
 *         },
 *         ConnectedSubnetRoutePolicy = new AzureNative.ManagedNetworkFabric.Inputs.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs
 *         {
 *             ExportRoutePolicyId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2",
 *         },
 *         Description = "creating L3 isolation domain",
 *         L3IsolationDomainName = "example-l3domain",
 *         Location = "eastus",
 *         NetworkFabricId = "/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName",
 *         RedistributeConnectedSubnets = "True",
 *         RedistributeStaticRoutes = "False",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewL3IsolationDomain(ctx, "l3IsolationDomain", &managednetworkfabric.L3IsolationDomainArgs{
 * 			AggregateRouteConfiguration: managednetworkfabric.AggregateRouteConfigurationResponse{
 * 				Ipv4Routes: managednetworkfabric.AggregateRouteArray{
 * 					&managednetworkfabric.AggregateRouteArgs{
 * 						Prefix: pulumi.String("10.0.0.0/24"),
 * 					},
 * 				},
 * 				Ipv6Routes: managednetworkfabric.AggregateRouteArray{
 * 					&managednetworkfabric.AggregateRouteArgs{
 * 						Prefix: pulumi.String("10.0.0.1"),
 * 					},
 * 				},
 * 			},
 * 			ConnectedSubnetRoutePolicy: &managednetworkfabric.L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs{
 * 				ExportRoutePolicyId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2"),
 * 			},
 * 			Description:                  pulumi.String("creating L3 isolation domain"),
 * 			L3IsolationDomainName:        pulumi.String("example-l3domain"),
 * 			Location:                     pulumi.String("eastus"),
 * 			NetworkFabricId:              pulumi.String("/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName"),
 * 			RedistributeConnectedSubnets: pulumi.String("True"),
 * 			RedistributeStaticRoutes:     pulumi.String("False"),
 * 			ResourceGroupName:            pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.L3IsolationDomain;
 * import com.pulumi.azurenative.managednetworkfabric.L3IsolationDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var l3IsolationDomain = new L3IsolationDomain("l3IsolationDomain", L3IsolationDomainArgs.builder()
 *             .aggregateRouteConfiguration(Map.ofEntries(
 *                 Map.entry("ipv4Routes", Map.of("prefix", "10.0.0.0/24")),
 *                 Map.entry("ipv6Routes", Map.of("prefix", "10.0.0.1"))
 *             ))
 *             .connectedSubnetRoutePolicy(Map.of("exportRoutePolicyId", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2"))
 *             .description("creating L3 isolation domain")
 *             .l3IsolationDomainName("example-l3domain")
 *             .location("eastus")
 *             .networkFabricId("/subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/networkFabrics/FabricName")
 *             .redistributeConnectedSubnets("True")
 *             .redistributeStaticRoutes("False")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:L3IsolationDomain example-l3domain /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/{l3IsolationDomainName}
 * ```
 * @property aggregateRouteConfiguration List of Ipv4 and Ipv6 route configurations.
 * @property annotation Switch configuration description.
 * @property connectedSubnetRoutePolicy Connected Subnet RoutePolicy
 * @property description L3 Isolation Domain description.
 * @property l3IsolationDomainName Name of the L3 Isolation Domain
 * @property location The geo-location where the resource lives
 * @property networkFabricId Network Fabric ARM resource id.
 * @property redistributeConnectedSubnets Advertise Connected Subnets. Ex: "True" | "False".
 * @property redistributeStaticRoutes Advertise Static Routes. Ex: "True" | "False".
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class L3IsolationDomainArgs(
    public val aggregateRouteConfiguration: Output<AggregateRouteConfigurationArgs>? = null,
    public val `annotation`: Output<String>? = null,
    public val connectedSubnetRoutePolicy:
    Output<L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs>? = null,
    public val description: Output<String>? = null,
    public val l3IsolationDomainName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkFabricId: Output<String>? = null,
    public val redistributeConnectedSubnets: Output<Either<String, RedistributeConnectedSubnets>>? =
        null,
    public val redistributeStaticRoutes: Output<Either<String, RedistributeStaticRoutes>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.L3IsolationDomainArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.L3IsolationDomainArgs =
        com.pulumi.azurenative.managednetworkfabric.L3IsolationDomainArgs.builder()
            .aggregateRouteConfiguration(
                aggregateRouteConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .connectedSubnetRoutePolicy(
                connectedSubnetRoutePolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .l3IsolationDomainName(l3IsolationDomainName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkFabricId(networkFabricId?.applyValue({ args0 -> args0 }))
            .redistributeConnectedSubnets(
                redistributeConnectedSubnets?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .redistributeStaticRoutes(
                redistributeStaticRoutes?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [L3IsolationDomainArgs].
 */
@PulumiTagMarker
public class L3IsolationDomainArgsBuilder internal constructor() {
    private var aggregateRouteConfiguration: Output<AggregateRouteConfigurationArgs>? = null

    private var `annotation`: Output<String>? = null

    private var connectedSubnetRoutePolicy:
        Output<L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs>? = null

    private var description: Output<String>? = null

    private var l3IsolationDomainName: Output<String>? = null

    private var location: Output<String>? = null

    private var networkFabricId: Output<String>? = null

    private var redistributeConnectedSubnets: Output<Either<String, RedistributeConnectedSubnets>>? =
        null

    private var redistributeStaticRoutes: Output<Either<String, RedistributeStaticRoutes>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of Ipv4 and Ipv6 route configurations.
     */
    @JvmName("dilxfbtlfwafxqjv")
    public suspend fun aggregateRouteConfiguration(`value`: Output<AggregateRouteConfigurationArgs>) {
        this.aggregateRouteConfiguration = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("vfyiakkmjhmlwnwi")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Connected Subnet RoutePolicy
     */
    @JvmName("uhekufddrhfwthnq")
    public suspend
    fun connectedSubnetRoutePolicy(`value`: Output<L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs>) {
        this.connectedSubnetRoutePolicy = value
    }

    /**
     * @param value L3 Isolation Domain description.
     */
    @JvmName("ncyqdthqmilfbpuh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the L3 Isolation Domain
     */
    @JvmName("whlhrwhfuhufvxno")
    public suspend fun l3IsolationDomainName(`value`: Output<String>) {
        this.l3IsolationDomainName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ihbuyyvpwepjankt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Network Fabric ARM resource id.
     */
    @JvmName("kyumbswvwvdgwvrc")
    public suspend fun networkFabricId(`value`: Output<String>) {
        this.networkFabricId = value
    }

    /**
     * @param value Advertise Connected Subnets. Ex: "True" | "False".
     */
    @JvmName("edtouyuctsrnsklm")
    public suspend
    fun redistributeConnectedSubnets(`value`: Output<Either<String, RedistributeConnectedSubnets>>) {
        this.redistributeConnectedSubnets = value
    }

    /**
     * @param value Advertise Static Routes. Ex: "True" | "False".
     */
    @JvmName("lqpbvhfttbthjppa")
    public suspend
    fun redistributeStaticRoutes(`value`: Output<Either<String, RedistributeStaticRoutes>>) {
        this.redistributeStaticRoutes = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("smiwykgvpqxydutb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wtbwevtsgjunhhkq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of Ipv4 and Ipv6 route configurations.
     */
    @JvmName("iyloinvabtbbgiau")
    public suspend fun aggregateRouteConfiguration(`value`: AggregateRouteConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregateRouteConfiguration = mapped
    }

    /**
     * @param argument List of Ipv4 and Ipv6 route configurations.
     */
    @JvmName("aokreieacrosupvv")
    public suspend
    fun aggregateRouteConfiguration(argument: suspend AggregateRouteConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AggregateRouteConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aggregateRouteConfiguration = mapped
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("utxmebpbcvyqwrpg")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Connected Subnet RoutePolicy
     */
    @JvmName("grdqnvfgajxijmri")
    public suspend
    fun connectedSubnetRoutePolicy(`value`: L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectedSubnetRoutePolicy = mapped
    }

    /**
     * @param argument Connected Subnet RoutePolicy
     */
    @JvmName("byusjnuxxrpjbouy")
    public suspend
    fun connectedSubnetRoutePolicy(argument: suspend L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgsBuilder.() -> Unit) {
        val toBeMapped =
            L3IsolationDomainPatchPropertiesConnectedSubnetRoutePolicyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.connectedSubnetRoutePolicy = mapped
    }

    /**
     * @param value L3 Isolation Domain description.
     */
    @JvmName("skybfioymiqqfpps")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the L3 Isolation Domain
     */
    @JvmName("bxdrrjsyfkxycgmq")
    public suspend fun l3IsolationDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l3IsolationDomainName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dvnswiyltrtsmlpy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Network Fabric ARM resource id.
     */
    @JvmName("tsdtpuxgguxdnadq")
    public suspend fun networkFabricId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricId = mapped
    }

    /**
     * @param value Advertise Connected Subnets. Ex: "True" | "False".
     */
    @JvmName("fsymfoecfagscdms")
    public suspend
    fun redistributeConnectedSubnets(`value`: Either<String, RedistributeConnectedSubnets>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redistributeConnectedSubnets = mapped
    }

    /**
     * @param value Advertise Connected Subnets. Ex: "True" | "False".
     */
    @JvmName("bpcqryciraqdqjyc")
    public fun redistributeConnectedSubnets(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RedistributeConnectedSubnets>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redistributeConnectedSubnets = mapped
    }

    /**
     * @param value Advertise Connected Subnets. Ex: "True" | "False".
     */
    @JvmName("twqwjrcaibfgublx")
    public fun redistributeConnectedSubnets(`value`: RedistributeConnectedSubnets) {
        val toBeMapped = Either.ofRight<String, RedistributeConnectedSubnets>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redistributeConnectedSubnets = mapped
    }

    /**
     * @param value Advertise Static Routes. Ex: "True" | "False".
     */
    @JvmName("gsfilsllkgqfjqye")
    public suspend fun redistributeStaticRoutes(`value`: Either<String, RedistributeStaticRoutes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redistributeStaticRoutes = mapped
    }

    /**
     * @param value Advertise Static Routes. Ex: "True" | "False".
     */
    @JvmName("ymvmybcqnspfwxub")
    public fun redistributeStaticRoutes(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RedistributeStaticRoutes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redistributeStaticRoutes = mapped
    }

    /**
     * @param value Advertise Static Routes. Ex: "True" | "False".
     */
    @JvmName("hdenxwddfylxinsu")
    public fun redistributeStaticRoutes(`value`: RedistributeStaticRoutes) {
        val toBeMapped = Either.ofRight<String, RedistributeStaticRoutes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redistributeStaticRoutes = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nnbgwiybwnboskkv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("itmpvcfiroqjyhsw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("geoapukhskkghtqj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): L3IsolationDomainArgs = L3IsolationDomainArgs(
        aggregateRouteConfiguration = aggregateRouteConfiguration,
        `annotation` = `annotation`,
        connectedSubnetRoutePolicy = connectedSubnetRoutePolicy,
        description = description,
        l3IsolationDomainName = l3IsolationDomainName,
        location = location,
        networkFabricId = networkFabricId,
        redistributeConnectedSubnets = redistributeConnectedSubnets,
        redistributeStaticRoutes = redistributeStaticRoutes,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
