@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NeighborGroupArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.NeighborGroupDestinationArgs
import com.pulumi.azurenative.managednetworkfabric.kotlin.inputs.NeighborGroupDestinationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the Neighbor Group.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### NeighborGroups_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var neighborGroup = new AzureNative.ManagedNetworkFabric.NeighborGroup("neighborGroup", new()
 *     {
 *         Annotation = "annotation",
 *         Destination = new AzureNative.ManagedNetworkFabric.Inputs.NeighborGroupDestinationArgs
 *         {
 *             Ipv4Addresses = new[]
 *             {
 *                 "10.10.10.10",
 *                 "20.10.10.10",
 *                 "30.10.10.10",
 *                 "40.10.10.10",
 *                 "50.10.10.10",
 *                 "60.10.10.10",
 *                 "70.10.10.10",
 *                 "80.10.10.10",
 *                 "90.10.10.10",
 *             },
 *             Ipv6Addresses = new[]
 *             {
 *                 "2F::/100",
 *             },
 *         },
 *         Location = "eastus",
 *         NeighborGroupName = "example-neighborGroup",
 *         ResourceGroupName = "example-rg",
 *         Tags =
 *         {
 *             { "key8107", "1234" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNeighborGroup(ctx, "neighborGroup", &managednetworkfabric.NeighborGroupArgs{
 * 			Annotation: pulumi.String("annotation"),
 * 			Destination: &managednetworkfabric.NeighborGroupDestinationArgs{
 * 				Ipv4Addresses: pulumi.StringArray{
 * 					pulumi.String("10.10.10.10"),
 * 					pulumi.String("20.10.10.10"),
 * 					pulumi.String("30.10.10.10"),
 * 					pulumi.String("40.10.10.10"),
 * 					pulumi.String("50.10.10.10"),
 * 					pulumi.String("60.10.10.10"),
 * 					pulumi.String("70.10.10.10"),
 * 					pulumi.String("80.10.10.10"),
 * 					pulumi.String("90.10.10.10"),
 * 				},
 * 				Ipv6Addresses: pulumi.StringArray{
 * 					pulumi.String("2F::/100"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			NeighborGroupName: pulumi.String("example-neighborGroup"),
 * 			ResourceGroupName: pulumi.String("example-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key8107": pulumi.String("1234"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NeighborGroup;
 * import com.pulumi.azurenative.managednetworkfabric.NeighborGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var neighborGroup = new NeighborGroup("neighborGroup", NeighborGroupArgs.builder()
 *             .annotation("annotation")
 *             .destination(Map.ofEntries(
 *                 Map.entry("ipv4Addresses",
 *                     "10.10.10.10",
 *                     "20.10.10.10",
 *                     "30.10.10.10",
 *                     "40.10.10.10",
 *                     "50.10.10.10",
 *                     "60.10.10.10",
 *                     "70.10.10.10",
 *                     "80.10.10.10",
 *                     "90.10.10.10"),
 *                 Map.entry("ipv6Addresses", "2F::/100")
 *             ))
 *             .location("eastus")
 *             .neighborGroupName("example-neighborGroup")
 *             .resourceGroupName("example-rg")
 *             .tags(Map.of("key8107", "1234"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NeighborGroup example-neighborGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/neighborGroups/{neighborGroupName}
 * ```
 * @property annotation Switch configuration description.
 * @property destination An array of destination IPv4 Addresses or IPv6 Addresses.
 * @property location The geo-location where the resource lives
 * @property neighborGroupName Name of the Neighbor Group.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NeighborGroupArgs(
    public val `annotation`: Output<String>? = null,
    public val destination: Output<NeighborGroupDestinationArgs>? = null,
    public val location: Output<String>? = null,
    public val neighborGroupName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NeighborGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.NeighborGroupArgs =
        com.pulumi.azurenative.managednetworkfabric.NeighborGroupArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .neighborGroupName(neighborGroupName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NeighborGroupArgs].
 */
@PulumiTagMarker
public class NeighborGroupArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var destination: Output<NeighborGroupDestinationArgs>? = null

    private var location: Output<String>? = null

    private var neighborGroupName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("aiglnqbtjbaewoea")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value An array of destination IPv4 Addresses or IPv6 Addresses.
     */
    @JvmName("ohrofljxgqguvnke")
    public suspend fun destination(`value`: Output<NeighborGroupDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jpbgbhwghmxpqpxr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Neighbor Group.
     */
    @JvmName("anmwujswegddlofx")
    public suspend fun neighborGroupName(`value`: Output<String>) {
        this.neighborGroupName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nscorxawruhyisgj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ahcrfhobbhwepqtt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("terxvlheuvosdski")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value An array of destination IPv4 Addresses or IPv6 Addresses.
     */
    @JvmName("wvfeyfneyycrldqv")
    public suspend fun destination(`value`: NeighborGroupDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument An array of destination IPv4 Addresses or IPv6 Addresses.
     */
    @JvmName("ircbenxuhvcvhdhr")
    public suspend fun destination(argument: suspend NeighborGroupDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = NeighborGroupDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("efawdqkawxjpyxjo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Neighbor Group.
     */
    @JvmName("kwbtmoauwkhfxxbs")
    public suspend fun neighborGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neighborGroupName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pyqrikjvegfkqqkw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("frjwksggqwnujpki")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nfupkbhrvbeeatyh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NeighborGroupArgs = NeighborGroupArgs(
        `annotation` = `annotation`,
        destination = destination,
        location = location,
        neighborGroupName = neighborGroupName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
