@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [NetworkPacketBroker].
 */
@PulumiTagMarker
public class NetworkPacketBrokerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkPacketBrokerArgs = NetworkPacketBrokerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkPacketBrokerArgsBuilder.() -> Unit) {
        val builder = NetworkPacketBrokerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkPacketBroker {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.NetworkPacketBroker(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkPacketBroker(builtJavaResource)
    }
}

/**
 * The NetworkPacketBroker resource definition.
 * Azure REST API version: 2023-06-15.
 * ## Example Usage
 * ### NetworkPacketBrokers_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkPacketBroker = new AzureNative.ManagedNetworkFabric.NetworkPacketBroker("networkPacketBroker", new()
 *     {
 *         Location = "eastuseuap",
 *         NetworkFabricId = "/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabrics/example-networkFabric",
 *         NetworkPacketBrokerName = "example-networkPacketBroker",
 *         ResourceGroupName = "example-rg",
 *         Tags =
 *         {
 *             { "key2806", "key" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkPacketBroker(ctx, "networkPacketBroker", &managednetworkfabric.NetworkPacketBrokerArgs{
 * 			Location:                pulumi.String("eastuseuap"),
 * 			NetworkFabricId:         pulumi.String("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabrics/example-networkFabric"),
 * 			NetworkPacketBrokerName: pulumi.String("example-networkPacketBroker"),
 * 			ResourceGroupName:       pulumi.String("example-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key2806": pulumi.String("key"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkPacketBroker;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkPacketBrokerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkPacketBroker = new NetworkPacketBroker("networkPacketBroker", NetworkPacketBrokerArgs.builder()
 *             .location("eastuseuap")
 *             .networkFabricId("/subscriptions/1234ABCD-0A1B-1234-5678-123456ABCDEF/resourcegroups/example-rg/providers/Microsoft.ManagedNetworkFabric/networkFabrics/example-networkFabric")
 *             .networkPacketBrokerName("example-networkPacketBroker")
 *             .resourceGroupName("example-rg")
 *             .tags(Map.of("key2806", "key"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkPacketBroker example-networkPacketBroker /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkPacketBrokers/{networkPacketBrokerName}
 * ```
 */
public class NetworkPacketBroker internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.NetworkPacketBroker,
) : KotlinCustomResource(javaResource, NetworkPacketBrokerMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of neighbor group IDs configured on NPB.
     */
    public val neighborGroupIds: Output<List<String>>
        get() = javaResource.neighborGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of ARM resource IDs of Network Devices [NPB].
     */
    public val networkDeviceIds: Output<List<String>>
        get() = javaResource.networkDeviceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * ARM resource ID of the Network Fabric.
     */
    public val networkFabricId: Output<String>
        get() = javaResource.networkFabricId().applyValue({ args0 -> args0 })

    /**
     * List of network Tap IDs configured on NPB.
     */
    public val networkTapIds: Output<List<String>>
        get() = javaResource.networkTapIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of network interfaces across NPB devices that are used to mirror source traffic.
     */
    public val sourceInterfaceIds: Output<List<String>>
        get() = javaResource.sourceInterfaceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NetworkPacketBrokerMapper : ResourceMapper<NetworkPacketBroker> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.NetworkPacketBroker::class == javaResource::class

    override fun map(javaResource: Resource): NetworkPacketBroker = NetworkPacketBroker(
        javaResource
            as com.pulumi.azurenative.managednetworkfabric.NetworkPacketBroker,
    )
}

/**
 * @see [NetworkPacketBroker].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkPacketBroker].
 */
public suspend fun networkPacketBroker(
    name: String,
    block: suspend NetworkPacketBrokerResourceBuilder.() -> Unit,
): NetworkPacketBroker {
    val builder = NetworkPacketBrokerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkPacketBroker].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkPacketBroker(name: String): NetworkPacketBroker {
    val builder = NetworkPacketBrokerResourceBuilder()
    builder.name(name)
    return builder.build()
}
