@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.NetworkRackArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The NetworkRack resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### NetworkRacks_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkRack = new AzureNative.ManagedNetworkFabric.NetworkRack("networkRack", new()
 *     {
 *         Annotation = "null",
 *         Location = "eastus",
 *         NetworkFabricId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/networkFabricName",
 *         NetworkRackName = "networkRackName",
 *         NetworkRackSku = "RackSKU",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "keyID", "keyValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewNetworkRack(ctx, "networkRack", &managednetworkfabric.NetworkRackArgs{
 * 			Annotation:        pulumi.String("null"),
 * 			Location:          pulumi.String("eastus"),
 * 			NetworkFabricId:   pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/networkFabricName"),
 * 			NetworkRackName:   pulumi.String("networkRackName"),
 * 			NetworkRackSku:    pulumi.String("RackSKU"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"keyID": pulumi.String("keyValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkRack;
 * import com.pulumi.azurenative.managednetworkfabric.NetworkRackArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkRack = new NetworkRack("networkRack", NetworkRackArgs.builder()
 *             .annotation("null")
 *             .location("eastus")
 *             .networkFabricId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabrics/networkFabricName")
 *             .networkRackName("networkRackName")
 *             .networkRackSku("RackSKU")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("keyID", "keyValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:NetworkRack networkRackName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/networkRacks/{networkRackName}
 * ```
 * @property annotation Switch configuration description.
 * @property location The geo-location where the resource lives
 * @property networkFabricId Network Fabric ARM resource id.
 * @property networkRackName Name of the Network Rack
 * @property networkRackSku Network Rack SKU name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NetworkRackArgs(
    public val `annotation`: Output<String>? = null,
    public val location: Output<String>? = null,
    public val networkFabricId: Output<String>? = null,
    public val networkRackName: Output<String>? = null,
    public val networkRackSku: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.NetworkRackArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.NetworkRackArgs =
        com.pulumi.azurenative.managednetworkfabric.NetworkRackArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkFabricId(networkFabricId?.applyValue({ args0 -> args0 }))
            .networkRackName(networkRackName?.applyValue({ args0 -> args0 }))
            .networkRackSku(networkRackSku?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkRackArgs].
 */
@PulumiTagMarker
public class NetworkRackArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var location: Output<String>? = null

    private var networkFabricId: Output<String>? = null

    private var networkRackName: Output<String>? = null

    private var networkRackSku: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("nifbwxqdbaphqikb")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ilvvhdklkchcuora")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Network Fabric ARM resource id.
     */
    @JvmName("nqbcegohydyuylwm")
    public suspend fun networkFabricId(`value`: Output<String>) {
        this.networkFabricId = value
    }

    /**
     * @param value Name of the Network Rack
     */
    @JvmName("tjupluujaounmrgg")
    public suspend fun networkRackName(`value`: Output<String>) {
        this.networkRackName = value
    }

    /**
     * @param value Network Rack SKU name.
     */
    @JvmName("njidevvlsfwdsdgo")
    public suspend fun networkRackSku(`value`: Output<String>) {
        this.networkRackSku = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jrkebekxbnyrirpl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gxbetndcbrpejbfo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("ncwuptgdkuhmvspv")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ybsbuisvcufmcagu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Network Fabric ARM resource id.
     */
    @JvmName("tqxngvkqijrbvpdu")
    public suspend fun networkFabricId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFabricId = mapped
    }

    /**
     * @param value Name of the Network Rack
     */
    @JvmName("qpefhwqvghidxvjq")
    public suspend fun networkRackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRackName = mapped
    }

    /**
     * @param value Network Rack SKU name.
     */
    @JvmName("gsvqsfihiifqrnxa")
    public suspend fun networkRackSku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRackSku = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cdiaqjdlhkkvmeac")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jcwvrsunvhepksnd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cvjoetfqalhvfkdw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkRackArgs = NetworkRackArgs(
        `annotation` = `annotation`,
        location = location,
        networkFabricId = networkFabricId,
        networkRackName = networkRackName,
        networkRackSku = networkRackSku,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
