@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin

import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.RoutePolicyStatementPropertiesResponse
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.RoutePolicyStatementPropertiesResponse.Companion.toKotlin as routePolicyStatementPropertiesResponseToKotlin
import com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RoutePolicy].
 */
@PulumiTagMarker
public class RoutePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoutePolicyArgs = RoutePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoutePolicyArgsBuilder.() -> Unit) {
        val builder = RoutePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RoutePolicy {
        val builtJavaResource =
            com.pulumi.azurenative.managednetworkfabric.RoutePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RoutePolicy(builtJavaResource)
    }
}

/**
 * The RoutePolicy resource definition.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2023-02-01-preview.
 * Other available API versions: 2023-06-15.
 * ## Example Usage
 * ### RoutePolicies_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var routePolicy = new AzureNative.ManagedNetworkFabric.RoutePolicy("routePolicy", new()
 *     {
 *         Annotation = "annotationValue",
 *         Location = "EastUS",
 *         ResourceGroupName = "rgRoutePolicies",
 *         RoutePolicyName = "routePolicyName",
 *         Statements = new[]
 *         {
 *             new AzureNative.ManagedNetworkFabric.Inputs.RoutePolicyStatementPropertiesArgs
 *             {
 *                 Action = new AzureNative.ManagedNetworkFabric.Inputs.StatementActionPropertiesArgs
 *                 {
 *                     ActionType = "Permit",
 *                     IpCommunityProperties = new AzureNative.ManagedNetworkFabric.Inputs.ActionIpCommunityPropertiesArgs
 *                     {
 *                         Add = new AzureNative.ManagedNetworkFabric.Inputs.IpCommunityIdListArgs
 *                         {
 *                             IpCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName",
 *                             },
 *                         },
 *                         Delete = new AzureNative.ManagedNetworkFabric.Inputs.IpCommunityIdListArgs
 *                         {
 *                             IpCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName",
 *                             },
 *                         },
 *                         Set = new AzureNative.ManagedNetworkFabric.Inputs.IpCommunityIdListArgs
 *                         {
 *                             IpCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName",
 *                             },
 *                         },
 *                     },
 *                     IpExtendedCommunityProperties = new AzureNative.ManagedNetworkFabric.Inputs.ActionIpExtendedCommunityPropertiesArgs
 *                     {
 *                         Add = new AzureNative.ManagedNetworkFabric.Inputs.IpExtendedCommunityIdListArgs
 *                         {
 *                             IpExtendedCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName",
 *                             },
 *                         },
 *                         Delete = new AzureNative.ManagedNetworkFabric.Inputs.IpExtendedCommunityIdListArgs
 *                         {
 *                             IpExtendedCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName",
 *                             },
 *                         },
 *                         Set = new AzureNative.ManagedNetworkFabric.Inputs.IpExtendedCommunityIdListArgs
 *                         {
 *                             IpExtendedCommunityIds = new[]
 *                             {
 *                                 "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName",
 *                             },
 *                         },
 *                     },
 *                     LocalPreference = 20,
 *                 },
 *                 Annotation = "annotationValue",
 *                 Condition = new AzureNative.ManagedNetworkFabric.Inputs.StatementConditionPropertiesArgs
 *                 {
 *                     IpCommunityIds = new[]
 *                     {
 *                         "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName",
 *                     },
 *                     IpExtendedCommunityIds = new[]
 *                     {
 *                         "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName",
 *                     },
 *                     IpPrefixId = "subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/example-ipPrefix",
 *                 },
 *                 SequenceNumber = 7,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "key8254", "" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/managednetworkfabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := managednetworkfabric.NewRoutePolicy(ctx, "routePolicy", &managednetworkfabric.RoutePolicyArgs{
 * 			Annotation:        pulumi.String("annotationValue"),
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("rgRoutePolicies"),
 * 			RoutePolicyName:   pulumi.String("routePolicyName"),
 * 			Statements: []managednetworkfabric.RoutePolicyStatementPropertiesArgs{
 * 				{
 * 					Action: {
 * 						ActionType: pulumi.String("Permit"),
 * 						IpCommunityProperties: {
 * 							Add: {
 * 								IpCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 * 								},
 * 							},
 * 							Delete: {
 * 								IpCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 * 								},
 * 							},
 * 							Set: {
 * 								IpCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 * 								},
 * 							},
 * 						},
 * 						IpExtendedCommunityProperties: {
 * 							Add: {
 * 								IpExtendedCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 * 								},
 * 							},
 * 							Delete: {
 * 								IpExtendedCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 * 								},
 * 							},
 * 							Set: {
 * 								IpExtendedCommunityIds: pulumi.StringArray{
 * 									pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 * 								},
 * 							},
 * 						},
 * 						LocalPreference: pulumi.Float64(20),
 * 					},
 * 					Annotation: pulumi.String("annotationValue"),
 * 					Condition: {
 * 						IpCommunityIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 * 						},
 * 						IpExtendedCommunityIds: pulumi.StringArray{
 * 							pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 * 						},
 * 						IpPrefixId: pulumi.String("subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/example-ipPrefix"),
 * 					},
 * 					SequenceNumber: pulumi.Float64(7),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key8254": pulumi.String(""),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.managednetworkfabric.RoutePolicy;
 * import com.pulumi.azurenative.managednetworkfabric.RoutePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var routePolicy = new RoutePolicy("routePolicy", RoutePolicyArgs.builder()
 *             .annotation("annotationValue")
 *             .location("EastUS")
 *             .resourceGroupName("rgRoutePolicies")
 *             .routePolicyName("routePolicyName")
 *             .statements(Map.ofEntries(
 *                 Map.entry("action", Map.ofEntries(
 *                     Map.entry("actionType", "Permit"),
 *                     Map.entry("ipCommunityProperties", Map.ofEntries(
 *                         Map.entry("add", Map.of("ipCommunityIds", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName")),
 *                         Map.entry("delete", Map.of("ipCommunityIds", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName")),
 *                         Map.entry("set", Map.of("ipCommunityIds", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"))
 *                     )),
 *                     Map.entry("ipExtendedCommunityProperties", Map.ofEntries(
 *                         Map.entry("add", Map.of("ipExtendedCommunityIds", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName")),
 *                         Map.entry("delete", Map.of("ipExtendedCommunityIds", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName")),
 *                         Map.entry("set", Map.of("ipExtendedCommunityIds", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"))
 *                     )),
 *                     Map.entry("localPreference", 20)
 *                 )),
 *                 Map.entry("annotation", "annotationValue"),
 *                 Map.entry("condition", Map.ofEntries(
 *                     Map.entry("ipCommunityIds", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipCommunities/ipCommunityName"),
 *                     Map.entry("ipExtendedCommunityIds", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/ipExtendedCommunities/ipExtendedCommunityName"),
 *                     Map.entry("ipPrefixId", "subscriptions/xxxxxx/resourceGroups/resourcegroupname/providers/Microsoft.ManagedNetworkFabric/ipPrefixes/example-ipPrefix")
 *                 )),
 *                 Map.entry("sequenceNumber", 7)
 *             ))
 *             .tags(Map.of("key8254", ""))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:managednetworkfabric:RoutePolicy routePolicyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedNetworkFabric/routePolicies/{routePolicyName}
 * ```
 */
public class RoutePolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.managednetworkfabric.RoutePolicy,
) : KotlinCustomResource(javaResource, RoutePolicyMapper) {
    /**
     * Switch configuration description.
     */
    public val `annotation`: Output<String>?
        get() = javaResource.`annotation`().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Route Policy statements.
     */
    public val statements: Output<List<RoutePolicyStatementPropertiesResponse>>
        get() = javaResource.statements().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    routePolicyStatementPropertiesResponseToKotlin(args0)
                })
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RoutePolicyMapper : ResourceMapper<RoutePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.managednetworkfabric.RoutePolicy::class == javaResource::class

    override fun map(javaResource: Resource): RoutePolicy = RoutePolicy(
        javaResource as
            com.pulumi.azurenative.managednetworkfabric.RoutePolicy,
    )
}

/**
 * @see [RoutePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RoutePolicy].
 */
public suspend fun routePolicy(name: String, block: suspend RoutePolicyResourceBuilder.() -> Unit):
    RoutePolicy {
    val builder = RoutePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RoutePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun routePolicy(name: String): RoutePolicy {
    val builder = RoutePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
