@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.ConnectedSubnetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connected Subnet properties.
 * @property annotation Switch configuration description.
 * @property prefix Prefix of the connected Subnet.
 */
public data class ConnectedSubnetArgs(
    public val `annotation`: Output<String>? = null,
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.ConnectedSubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.ConnectedSubnetArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.ConnectedSubnetArgs.builder()
            .`annotation`(`annotation`?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectedSubnetArgs].
 */
@PulumiTagMarker
public class ConnectedSubnetArgsBuilder internal constructor() {
    private var `annotation`: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value Switch configuration description.
     */
    @JvmName("bqqjekrqsdvuqifa")
    public suspend fun `annotation`(`value`: Output<String>) {
        this.`annotation` = value
    }

    /**
     * @param value Prefix of the connected Subnet.
     */
    @JvmName("asnugtgrtocmhari")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Switch configuration description.
     */
    @JvmName("gevwllyqprkigcmi")
    public suspend fun `annotation`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`annotation` = mapped
    }

    /**
     * @param value Prefix of the connected Subnet.
     */
    @JvmName("lpadjacpmaetkuga")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): ConnectedSubnetArgs = ConnectedSubnetArgs(
        `annotation` = `annotation`,
        prefix = prefix,
    )
}
