@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.FabricOptionBPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Option B configuration.
 * @property exportRouteTargets Route Targets to be applied for outgoing routes from CE.
 * @property importRouteTargets Route Targets to be applied for incoming routes into CE.
 */
public data class FabricOptionBPropertiesArgs(
    public val exportRouteTargets: Output<List<String>>,
    public val importRouteTargets: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.FabricOptionBPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.FabricOptionBPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.FabricOptionBPropertiesArgs.builder()
            .exportRouteTargets(exportRouteTargets.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .importRouteTargets(importRouteTargets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FabricOptionBPropertiesArgs].
 */
@PulumiTagMarker
public class FabricOptionBPropertiesArgsBuilder internal constructor() {
    private var exportRouteTargets: Output<List<String>>? = null

    private var importRouteTargets: Output<List<String>>? = null

    /**
     * @param value Route Targets to be applied for outgoing routes from CE.
     */
    @JvmName("woyhlidaqdpavily")
    public suspend fun exportRouteTargets(`value`: Output<List<String>>) {
        this.exportRouteTargets = value
    }

    @JvmName("jtvtmolrssxhhrgu")
    public suspend fun exportRouteTargets(vararg values: Output<String>) {
        this.exportRouteTargets = Output.all(values.asList())
    }

    /**
     * @param values Route Targets to be applied for outgoing routes from CE.
     */
    @JvmName("rdlfcryuyavgftnk")
    public suspend fun exportRouteTargets(values: List<Output<String>>) {
        this.exportRouteTargets = Output.all(values)
    }

    /**
     * @param value Route Targets to be applied for incoming routes into CE.
     */
    @JvmName("tnodflhxhthngcsb")
    public suspend fun importRouteTargets(`value`: Output<List<String>>) {
        this.importRouteTargets = value
    }

    @JvmName("vhwyrsdqntushmug")
    public suspend fun importRouteTargets(vararg values: Output<String>) {
        this.importRouteTargets = Output.all(values.asList())
    }

    /**
     * @param values Route Targets to be applied for incoming routes into CE.
     */
    @JvmName("wmmmnavcgsdusibq")
    public suspend fun importRouteTargets(values: List<Output<String>>) {
        this.importRouteTargets = Output.all(values)
    }

    /**
     * @param value Route Targets to be applied for outgoing routes from CE.
     */
    @JvmName("fwnosdousvblcqbx")
    public suspend fun exportRouteTargets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exportRouteTargets = mapped
    }

    /**
     * @param values Route Targets to be applied for outgoing routes from CE.
     */
    @JvmName("ssagnataqdeepaqi")
    public suspend fun exportRouteTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exportRouteTargets = mapped
    }

    /**
     * @param value Route Targets to be applied for incoming routes into CE.
     */
    @JvmName("dttaoinsxgiuprva")
    public suspend fun importRouteTargets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.importRouteTargets = mapped
    }

    /**
     * @param values Route Targets to be applied for incoming routes into CE.
     */
    @JvmName("vklphibllraidovo")
    public suspend fun importRouteTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.importRouteTargets = mapped
    }

    internal fun build(): FabricOptionBPropertiesArgs = FabricOptionBPropertiesArgs(
        exportRouteTargets = exportRouteTargets ?: throw PulumiNullFieldException("exportRouteTargets"),
        importRouteTargets = importRouteTargets ?: throw PulumiNullFieldException("importRouteTargets"),
    )
}
