@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetAccessControlListPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessControlListName Name of the Access Control List
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAccessControlListPlainArgs(
    public val accessControlListName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetAccessControlListPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetAccessControlListPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetAccessControlListPlainArgs.builder()
            .accessControlListName(accessControlListName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessControlListPlainArgs].
 */
@PulumiTagMarker
public class GetAccessControlListPlainArgsBuilder internal constructor() {
    private var accessControlListName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Access Control List
     */
    @JvmName("appuranwwuvxyjqq")
    public suspend fun accessControlListName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessControlListName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("efvkadisqtysqypn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAccessControlListPlainArgs = GetAccessControlListPlainArgs(
        accessControlListName = accessControlListName ?: throw
            PulumiNullFieldException("accessControlListName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
