@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetInternetGatewayRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property internetGatewayRuleName Name of the Internet Gateway rule.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetInternetGatewayRulePlainArgs(
    public val internetGatewayRuleName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetInternetGatewayRulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetInternetGatewayRulePlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetInternetGatewayRulePlainArgs.builder()
            .internetGatewayRuleName(internetGatewayRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInternetGatewayRulePlainArgs].
 */
@PulumiTagMarker
public class GetInternetGatewayRulePlainArgsBuilder internal constructor() {
    private var internetGatewayRuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Internet Gateway rule.
     */
    @JvmName("kwuviangfgqrflcy")
    public suspend fun internetGatewayRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.internetGatewayRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("esdeelvtbgnfqcmo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInternetGatewayRulePlainArgs = GetInternetGatewayRulePlainArgs(
        internetGatewayRuleName = internetGatewayRuleName ?: throw
            PulumiNullFieldException("internetGatewayRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
