@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetL3IsolationDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property l3IsolationDomainName Name of the L3 Isolation Domain
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetL3IsolationDomainPlainArgs(
    public val l3IsolationDomainName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetL3IsolationDomainPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetL3IsolationDomainPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetL3IsolationDomainPlainArgs.builder()
            .l3IsolationDomainName(l3IsolationDomainName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetL3IsolationDomainPlainArgs].
 */
@PulumiTagMarker
public class GetL3IsolationDomainPlainArgsBuilder internal constructor() {
    private var l3IsolationDomainName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the L3 Isolation Domain
     */
    @JvmName("tlfsdwtgironqhuq")
    public suspend fun l3IsolationDomainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.l3IsolationDomainName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aevtbutintvydmqc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetL3IsolationDomainPlainArgs = GetL3IsolationDomainPlainArgs(
        l3IsolationDomainName = l3IsolationDomainName ?: throw
            PulumiNullFieldException("l3IsolationDomainName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
