@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkDevicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkDeviceName Name of the Network Device
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkDevicePlainArgs(
    public val networkDeviceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkDevicePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkDevicePlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkDevicePlainArgs.builder()
            .networkDeviceName(networkDeviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkDevicePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkDevicePlainArgsBuilder internal constructor() {
    private var networkDeviceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Network Device
     */
    @JvmName("ljfysvontnwyopmr")
    public suspend fun networkDeviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkDeviceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gputuscitbneyutg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkDevicePlainArgs = GetNetworkDevicePlainArgs(
        networkDeviceName = networkDeviceName ?: throw PulumiNullFieldException("networkDeviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
