@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkDeviceStatusPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkDeviceName Name of the NetworkDevice.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkDeviceStatusPlainArgs(
    public val networkDeviceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkDeviceStatusPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkDeviceStatusPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkDeviceStatusPlainArgs.builder()
            .networkDeviceName(networkDeviceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkDeviceStatusPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkDeviceStatusPlainArgsBuilder internal constructor() {
    private var networkDeviceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the NetworkDevice.
     */
    @JvmName("qpmfkmqicivwumtu")
    public suspend fun networkDeviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkDeviceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kgdwmdfdyjhfaogf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkDeviceStatusPlainArgs = GetNetworkDeviceStatusPlainArgs(
        networkDeviceName = networkDeviceName ?: throw PulumiNullFieldException("networkDeviceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
