@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkPacketBrokerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkPacketBrokerName Name of the Network Packet Broker.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkPacketBrokerPlainArgs(
    public val networkPacketBrokerName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkPacketBrokerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkPacketBrokerPlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkPacketBrokerPlainArgs.builder()
            .networkPacketBrokerName(networkPacketBrokerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkPacketBrokerPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkPacketBrokerPlainArgsBuilder internal constructor() {
    private var networkPacketBrokerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Network Packet Broker.
     */
    @JvmName("ulvlrsynhmmcqxyp")
    public suspend fun networkPacketBrokerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkPacketBrokerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lgrfotunkdqwqjab")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkPacketBrokerPlainArgs = GetNetworkPacketBrokerPlainArgs(
        networkPacketBrokerName = networkPacketBrokerName ?: throw
            PulumiNullFieldException("networkPacketBrokerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
