@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkTapRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkTapRuleName Name of the Network Tap Rule.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkTapRulePlainArgs(
    public val networkTapRuleName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkTapRulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkTapRulePlainArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.GetNetworkTapRulePlainArgs.builder()
            .networkTapRuleName(networkTapRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkTapRulePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkTapRulePlainArgsBuilder internal constructor() {
    private var networkTapRuleName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Network Tap Rule.
     */
    @JvmName("nydustjrsjbvwpgl")
    public suspend fun networkTapRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkTapRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yucywrojpcbygkns")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkTapRulePlainArgs = GetNetworkTapRulePlainArgs(
        networkTapRuleName = networkTapRuleName ?: throw PulumiNullFieldException("networkTapRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
