@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.PortConditionArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.Layer4Protocol
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.PortType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Port condition that needs to be matched.
 * @property layer4Protocol Layer4 protocol type that needs to be matched.
 * @property portGroupNames List of the port Group Names that need to be matched.
 * @property portType Port type that needs to be matched.
 * @property ports List of the Ports that need to be matched.
 */
public data class PortConditionArgs(
    public val layer4Protocol: Output<Either<String, Layer4Protocol>>,
    public val portGroupNames: Output<List<String>>? = null,
    public val portType: Output<Either<String, PortType>>? = null,
    public val ports: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.PortConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.PortConditionArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.PortConditionArgs.builder()
            .layer4Protocol(
                layer4Protocol.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .portGroupNames(portGroupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .portType(
                portType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PortConditionArgs].
 */
@PulumiTagMarker
public class PortConditionArgsBuilder internal constructor() {
    private var layer4Protocol: Output<Either<String, Layer4Protocol>>? = null

    private var portGroupNames: Output<List<String>>? = null

    private var portType: Output<Either<String, PortType>>? = null

    private var ports: Output<List<String>>? = null

    /**
     * @param value Layer4 protocol type that needs to be matched.
     */
    @JvmName("texwfgoslrigobak")
    public suspend fun layer4Protocol(`value`: Output<Either<String, Layer4Protocol>>) {
        this.layer4Protocol = value
    }

    /**
     * @param value List of the port Group Names that need to be matched.
     */
    @JvmName("rbkunwdbufbxiuwc")
    public suspend fun portGroupNames(`value`: Output<List<String>>) {
        this.portGroupNames = value
    }

    @JvmName("tpodgwenmuxypuky")
    public suspend fun portGroupNames(vararg values: Output<String>) {
        this.portGroupNames = Output.all(values.asList())
    }

    /**
     * @param values List of the port Group Names that need to be matched.
     */
    @JvmName("hopemmermxbrutvc")
    public suspend fun portGroupNames(values: List<Output<String>>) {
        this.portGroupNames = Output.all(values)
    }

    /**
     * @param value Port type that needs to be matched.
     */
    @JvmName("mrcussumwgpnjstl")
    public suspend fun portType(`value`: Output<Either<String, PortType>>) {
        this.portType = value
    }

    /**
     * @param value List of the Ports that need to be matched.
     */
    @JvmName("avchgbldyjvmxaeg")
    public suspend fun ports(`value`: Output<List<String>>) {
        this.ports = value
    }

    @JvmName("tbxlhjqqonbdagbu")
    public suspend fun ports(vararg values: Output<String>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values List of the Ports that need to be matched.
     */
    @JvmName("hjsgaiptlonweqxs")
    public suspend fun ports(values: List<Output<String>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Layer4 protocol type that needs to be matched.
     */
    @JvmName("qynxfacabfjgpuyd")
    public suspend fun layer4Protocol(`value`: Either<String, Layer4Protocol>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layer4Protocol = mapped
    }

    /**
     * @param value Layer4 protocol type that needs to be matched.
     */
    @JvmName("mkpmqpmugmapolhh")
    public fun layer4Protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Layer4Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layer4Protocol = mapped
    }

    /**
     * @param value Layer4 protocol type that needs to be matched.
     */
    @JvmName("gpoxstuditteiinc")
    public fun layer4Protocol(`value`: Layer4Protocol) {
        val toBeMapped = Either.ofRight<String, Layer4Protocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.layer4Protocol = mapped
    }

    /**
     * @param value List of the port Group Names that need to be matched.
     */
    @JvmName("mtelivdxjfdgocwx")
    public suspend fun portGroupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portGroupNames = mapped
    }

    /**
     * @param values List of the port Group Names that need to be matched.
     */
    @JvmName("gahtgpqaxswlpkvl")
    public suspend fun portGroupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portGroupNames = mapped
    }

    /**
     * @param value Port type that needs to be matched.
     */
    @JvmName("ymqmldpnmclshdye")
    public suspend fun portType(`value`: Either<String, PortType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portType = mapped
    }

    /**
     * @param value Port type that needs to be matched.
     */
    @JvmName("thskxxpctfjkjvnt")
    public fun portType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PortType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portType = mapped
    }

    /**
     * @param value Port type that needs to be matched.
     */
    @JvmName("wbuvalvtjusvfrfo")
    public fun portType(`value`: PortType) {
        val toBeMapped = Either.ofRight<String, PortType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portType = mapped
    }

    /**
     * @param value List of the Ports that need to be matched.
     */
    @JvmName("yrhvvxdwysajqbno")
    public suspend fun ports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param values List of the Ports that need to be matched.
     */
    @JvmName("tvptmwjycnisrcam")
    public suspend fun ports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    internal fun build(): PortConditionArgs = PortConditionArgs(
        layer4Protocol = layer4Protocol ?: throw PulumiNullFieldException("layer4Protocol"),
        portGroupNames = portGroupNames,
        portType = portType,
        ports = ports,
    )
}
