@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.PortGroupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Port Group properties.
 * @property name The name of the port group.
 * @property ports List of the ports that need to be matched.
 */
public data class PortGroupPropertiesArgs(
    public val name: Output<String>? = null,
    public val ports: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.PortGroupPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.managednetworkfabric.inputs.PortGroupPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.PortGroupPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PortGroupPropertiesArgs].
 */
@PulumiTagMarker
public class PortGroupPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var ports: Output<List<String>>? = null

    /**
     * @param value The name of the port group.
     */
    @JvmName("mlmtklvlnwkqtejp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of the ports that need to be matched.
     */
    @JvmName("utjjbagnidduidyx")
    public suspend fun ports(`value`: Output<List<String>>) {
        this.ports = value
    }

    @JvmName("iihqqrgibldsrfhv")
    public suspend fun ports(vararg values: Output<String>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values List of the ports that need to be matched.
     */
    @JvmName("urjktplrknbfgpna")
    public suspend fun ports(values: List<Output<String>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value The name of the port group.
     */
    @JvmName("ndhavcwndxllqtdu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of the ports that need to be matched.
     */
    @JvmName("nkexkjikppklnwjx")
    public suspend fun ports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param values List of the ports that need to be matched.
     */
    @JvmName("aregpiyuunagdxxp")
    public suspend fun ports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    internal fun build(): PortGroupPropertiesArgs = PortGroupPropertiesArgs(
        name = name,
        ports = ports,
    )
}
