@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.StatementActionPropertiesArgs.builder
import com.pulumi.azurenative.managednetworkfabric.kotlin.enums.CommunityActionTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Route policy action properties.
 * @property actionType action. Example: Permit | Deny.
 * @property ipCommunityProperties IP Community Properties.
 * @property ipExtendedCommunityProperties IP Extended Community Properties.
 * @property localPreference localPreference of the route policy.
 */
public data class StatementActionPropertiesArgs(
    public val actionType: Output<Either<String, CommunityActionTypes>>,
    public val ipCommunityProperties: Output<ActionIpCommunityPropertiesArgs>? = null,
    public val ipExtendedCommunityProperties: Output<ActionIpExtendedCommunityPropertiesArgs>? = null,
    public val localPreference: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.StatementActionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.StatementActionPropertiesArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.StatementActionPropertiesArgs.builder()
            .actionType(
                actionType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipCommunityProperties(
                ipCommunityProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ipExtendedCommunityProperties(
                ipExtendedCommunityProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .localPreference(localPreference?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatementActionPropertiesArgs].
 */
@PulumiTagMarker
public class StatementActionPropertiesArgsBuilder internal constructor() {
    private var actionType: Output<Either<String, CommunityActionTypes>>? = null

    private var ipCommunityProperties: Output<ActionIpCommunityPropertiesArgs>? = null

    private var ipExtendedCommunityProperties: Output<ActionIpExtendedCommunityPropertiesArgs>? = null

    private var localPreference: Output<Double>? = null

    /**
     * @param value action. Example: Permit | Deny.
     */
    @JvmName("cfwamdwyscssbgpm")
    public suspend fun actionType(`value`: Output<Either<String, CommunityActionTypes>>) {
        this.actionType = value
    }

    /**
     * @param value IP Community Properties.
     */
    @JvmName("rxsxtfeejhgvwbta")
    public suspend fun ipCommunityProperties(`value`: Output<ActionIpCommunityPropertiesArgs>) {
        this.ipCommunityProperties = value
    }

    /**
     * @param value IP Extended Community Properties.
     */
    @JvmName("kpjwnnnotcovetes")
    public suspend
    fun ipExtendedCommunityProperties(`value`: Output<ActionIpExtendedCommunityPropertiesArgs>) {
        this.ipExtendedCommunityProperties = value
    }

    /**
     * @param value localPreference of the route policy.
     */
    @JvmName("byyfddnugacabpxs")
    public suspend fun localPreference(`value`: Output<Double>) {
        this.localPreference = value
    }

    /**
     * @param value action. Example: Permit | Deny.
     */
    @JvmName("taqpvaheuledaiid")
    public suspend fun actionType(`value`: Either<String, CommunityActionTypes>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value action. Example: Permit | Deny.
     */
    @JvmName("wceiaaiqmwqvqpjp")
    public fun actionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CommunityActionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value action. Example: Permit | Deny.
     */
    @JvmName("bghpeyptawicnymi")
    public fun actionType(`value`: CommunityActionTypes) {
        val toBeMapped = Either.ofRight<String, CommunityActionTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value IP Community Properties.
     */
    @JvmName("ctxedlqlrmwhwdrs")
    public suspend fun ipCommunityProperties(`value`: ActionIpCommunityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipCommunityProperties = mapped
    }

    /**
     * @param argument IP Community Properties.
     */
    @JvmName("toaqapahmlcpiemq")
    public suspend
    fun ipCommunityProperties(argument: suspend ActionIpCommunityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ActionIpCommunityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipCommunityProperties = mapped
    }

    /**
     * @param value IP Extended Community Properties.
     */
    @JvmName("rqoenbesmvwmglbe")
    public suspend
    fun ipExtendedCommunityProperties(`value`: ActionIpExtendedCommunityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipExtendedCommunityProperties = mapped
    }

    /**
     * @param argument IP Extended Community Properties.
     */
    @JvmName("fekvycqhljeisujw")
    public suspend
    fun ipExtendedCommunityProperties(argument: suspend ActionIpExtendedCommunityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ActionIpExtendedCommunityPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ipExtendedCommunityProperties = mapped
    }

    /**
     * @param value localPreference of the route policy.
     */
    @JvmName("yueqfbmrtrfpqhyv")
    public suspend fun localPreference(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localPreference = mapped
    }

    internal fun build(): StatementActionPropertiesArgs = StatementActionPropertiesArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        ipCommunityProperties = ipCommunityProperties,
        ipExtendedCommunityProperties = ipExtendedCommunityProperties,
        localPreference = localPreference,
    )
}
