@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.inputs

import com.pulumi.azurenative.managednetworkfabric.inputs.TerminalServerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network and credentials configuration currently applied to terminal server.
 * @property password Password for the terminal server connection.
 * @property primaryIpv4Prefix IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property primaryIpv6Prefix IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv4Prefix Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property secondaryIpv6Prefix Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
 * @property serialNumber Serial Number of Terminal server.
 * @property username Username for the terminal server connection.
 */
public data class TerminalServerConfigurationArgs(
    public val password: Output<String>,
    public val primaryIpv4Prefix: Output<String>,
    public val primaryIpv6Prefix: Output<String>? = null,
    public val secondaryIpv4Prefix: Output<String>,
    public val secondaryIpv6Prefix: Output<String>? = null,
    public val serialNumber: Output<String>? = null,
    public val username: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.managednetworkfabric.inputs.TerminalServerConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.managednetworkfabric.inputs.TerminalServerConfigurationArgs =
        com.pulumi.azurenative.managednetworkfabric.inputs.TerminalServerConfigurationArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .primaryIpv4Prefix(primaryIpv4Prefix.applyValue({ args0 -> args0 }))
            .primaryIpv6Prefix(primaryIpv6Prefix?.applyValue({ args0 -> args0 }))
            .secondaryIpv4Prefix(secondaryIpv4Prefix.applyValue({ args0 -> args0 }))
            .secondaryIpv6Prefix(secondaryIpv6Prefix?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TerminalServerConfigurationArgs].
 */
@PulumiTagMarker
public class TerminalServerConfigurationArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var primaryIpv4Prefix: Output<String>? = null

    private var primaryIpv6Prefix: Output<String>? = null

    private var secondaryIpv4Prefix: Output<String>? = null

    private var secondaryIpv6Prefix: Output<String>? = null

    private var serialNumber: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Password for the terminal server connection.
     */
    @JvmName("fudakpyopvwoxdew")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("hpfnemkhuwcviqpj")
    public suspend fun primaryIpv4Prefix(`value`: Output<String>) {
        this.primaryIpv4Prefix = value
    }

    /**
     * @param value IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("afoivwqhevdjbwbi")
    public suspend fun primaryIpv6Prefix(`value`: Output<String>) {
        this.primaryIpv6Prefix = value
    }

    /**
     * @param value Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("avgagwrbpocmteeu")
    public suspend fun secondaryIpv4Prefix(`value`: Output<String>) {
        this.secondaryIpv4Prefix = value
    }

    /**
     * @param value Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("upprcrnwqgtygiiv")
    public suspend fun secondaryIpv6Prefix(`value`: Output<String>) {
        this.secondaryIpv6Prefix = value
    }

    /**
     * @param value Serial Number of Terminal server.
     */
    @JvmName("fmcpwulnimbgting")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value Username for the terminal server connection.
     */
    @JvmName("anikukgfvxidgrvg")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Password for the terminal server connection.
     */
    @JvmName("ihvovgylpumcrtya")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.0/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("hlblryeuwconqjua")
    public suspend fun primaryIpv4Prefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryIpv4Prefix = mapped
    }

    /**
     * @param value IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a0/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("gnqcpyscefuvikiq")
    public suspend fun primaryIpv6Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryIpv6Prefix = mapped
    }

    /**
     * @param value Secondary IPv4 Address Prefix of CE-PE interconnect links. Example: 172.31.0.20/31. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("qmicrnohuihdopch")
    public suspend fun secondaryIpv4Prefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryIpv4Prefix = mapped
    }

    /**
     * @param value Secondary IPv6 Address Prefix of CE-PE interconnect links. Example: 3FFE:FFFF:0:CD30::a4/126. The values can be specified at the time of creation or can be updated afterwards. Any update to the values post-provisioning may disrupt traffic. The 1st and 3rd IPs are to be configured on CE1 and CE2 for Option B interfaces. The 2nd and 4th IPs are to be configured on PE1 and PE2 for Option B interfaces.
     */
    @JvmName("qxcpqlefyecrjiau")
    public suspend fun secondaryIpv6Prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryIpv6Prefix = mapped
    }

    /**
     * @param value Serial Number of Terminal server.
     */
    @JvmName("tgbednpyfiperdgf")
    public suspend fun serialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value Username for the terminal server connection.
     */
    @JvmName("lambviiulmbqwasc")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): TerminalServerConfigurationArgs = TerminalServerConfigurationArgs(
        password = password ?: throw PulumiNullFieldException("password"),
        primaryIpv4Prefix = primaryIpv4Prefix ?: throw PulumiNullFieldException("primaryIpv4Prefix"),
        primaryIpv6Prefix = primaryIpv6Prefix,
        secondaryIpv4Prefix = secondaryIpv4Prefix ?: throw PulumiNullFieldException("secondaryIpv4Prefix"),
        secondaryIpv6Prefix = secondaryIpv6Prefix,
        serialNumber = serialNumber,
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
