@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Access Control List condition model.
 * @property action action. Example: allow | deny.
 * @property annotation Switch configuration description.
 * @property destinationAddress destinationAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
 * @property destinationPort destinationPort. Example: any | 1253
 * @property protocol TCP/IP protocol as defined in the list of IP protocol numbers. Example: 255 (any) | 0 | 1.
 * @property sequenceNumber sequenceNumber of the Access Control List.
 * @property sourceAddress sourceAddress. Example: any | 1.1.1.0/24 | 1.1.10.10
 * @property sourcePort sourcePort. Example: any | 1253
 */
public data class AccessControlListConditionPropertiesResponse(
    public val action: String,
    public val `annotation`: String? = null,
    public val destinationAddress: String,
    public val destinationPort: String,
    public val protocol: Int,
    public val sequenceNumber: Int,
    public val sourceAddress: String,
    public val sourcePort: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.AccessControlListConditionPropertiesResponse):
            AccessControlListConditionPropertiesResponse = AccessControlListConditionPropertiesResponse(
            action = javaType.action(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            destinationAddress = javaType.destinationAddress(),
            destinationPort = javaType.destinationPort(),
            protocol = javaType.protocol(),
            sequenceNumber = javaType.sequenceNumber(),
            sourceAddress = javaType.sourceAddress(),
            sourcePort = javaType.sourcePort(),
        )
    }
}
