@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * BGP configuration properties
 * @property allowAS Allows for routes to be received and processed even if the router detects its own ASN in the AS-Path. 0 is disable, Possible values are 1-10, default is 2.
 * @property allowASOverride Enable Or Disable state.
 * @property annotation Switch configuration description.
 * @property bfdConfiguration BFD configuration properties
 * @property defaultRouteOriginate Originate a defaultRoute. Ex: "True" | "False".
 * @property fabricASN ASN of Network Fabric. Example: 65048.
 * @property ipv4ListenRangePrefixes BGP Ipv4 ListenRange.
 * @property ipv4NeighborAddress List with stringified ipv4NeighborAddresses.
 * @property ipv6ListenRangePrefixes BGP Ipv6 ListenRange.
 * @property ipv6NeighborAddress List with stringified IPv6 Neighbor Address.
 * @property peerASN Peer ASN. Example: 65047.
 */
public data class BgpConfigurationResponse(
    public val allowAS: Int? = null,
    public val allowASOverride: String? = null,
    public val `annotation`: String? = null,
    public val bfdConfiguration: BfdConfigurationResponse? = null,
    public val defaultRouteOriginate: String? = null,
    public val fabricASN: Int,
    public val ipv4ListenRangePrefixes: List<String>? = null,
    public val ipv4NeighborAddress: List<NeighborAddressResponse>? = null,
    public val ipv6ListenRangePrefixes: List<String>? = null,
    public val ipv6NeighborAddress: List<NeighborAddressResponse>? = null,
    public val peerASN: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.BgpConfigurationResponse):
            BgpConfigurationResponse = BgpConfigurationResponse(
            allowAS = javaType.allowAS().map({ args0 -> args0 }).orElse(null),
            allowASOverride = javaType.allowASOverride().map({ args0 -> args0 }).orElse(null),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            bfdConfiguration = javaType.bfdConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.BfdConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultRouteOriginate = javaType.defaultRouteOriginate().map({ args0 -> args0 }).orElse(null),
            fabricASN = javaType.fabricASN(),
            ipv4ListenRangePrefixes = javaType.ipv4ListenRangePrefixes().map({ args0 -> args0 }),
            ipv4NeighborAddress = javaType.ipv4NeighborAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NeighborAddressResponse.Companion.toKotlin(args0)
                })
            }),
            ipv6ListenRangePrefixes = javaType.ipv6ListenRangePrefixes().map({ args0 -> args0 }),
            ipv6NeighborAddress = javaType.ipv6NeighborAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.NeighborAddressResponse.Companion.toKotlin(args0)
                })
            }),
            peerASN = javaType.peerASN(),
        )
    }
}
