@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the InternalNetwork item.
 * @property administrativeState Administrative state of the InternalNetwork. Example: Enabled | Disabled.
 * @property annotation Switch configuration description.
 * @property bfdDisabledOnResources List of resources the BFD for BGP is disabled on. Can be either entire NetworkFabric or NetworkRack.
 * @property bfdForStaticRoutesDisabledOnResources List of resources the BFD of StaticRoutes is disabled on. Can be either entire NetworkFabric or NetworkRack.
 * @property bgpConfiguration BGP configuration properties
 * @property bgpDisabledOnResources List of resources the BGP is disabled on. Can be either entire NetworkFabric or NetworkRack.
 * @property connectedIPv4Subnets List with object connected IPv4 Subnets.
 * @property connectedIPv6Subnets List with object connected IPv6 Subnets.
 * @property disabledOnResources List of resources the InternalNetwork is disabled on. Can be either entire NetworkFabric or NetworkRack.
 * @property exportRoutePolicyId ARM resource ID of importRoutePolicy.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property importRoutePolicyId ARM resource ID of importRoutePolicy.
 * @property mtu Maximum transmission unit. Default value is 1500.
 * @property name The name of the resource
 * @property provisioningState Gets the provisioning state of the resource.
 * @property staticRouteConfiguration Static Route Configuration properties.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vlanId Vlan identifier. Example: 1001.
 */
public data class GetInternalNetworkResult(
    public val administrativeState: String,
    public val `annotation`: String? = null,
    public val bfdDisabledOnResources: List<String>,
    public val bfdForStaticRoutesDisabledOnResources: List<String>,
    public val bgpConfiguration: BgpConfigurationResponse? = null,
    public val bgpDisabledOnResources: List<String>,
    public val connectedIPv4Subnets: List<ConnectedSubnetResponse>? = null,
    public val connectedIPv6Subnets: List<ConnectedSubnetResponse>? = null,
    public val disabledOnResources: List<String>,
    public val exportRoutePolicyId: String? = null,
    public val id: String,
    public val importRoutePolicyId: String? = null,
    public val mtu: Int? = null,
    public val name: String,
    public val provisioningState: String,
    public val staticRouteConfiguration: StaticRouteConfigurationResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val vlanId: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetInternalNetworkResult):
            GetInternalNetworkResult = GetInternalNetworkResult(
            administrativeState = javaType.administrativeState(),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            bfdDisabledOnResources = javaType.bfdDisabledOnResources().map({ args0 -> args0 }),
            bfdForStaticRoutesDisabledOnResources = javaType.bfdForStaticRoutesDisabledOnResources().map({ args0 ->
                args0
            }),
            bgpConfiguration = javaType.bgpConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.BgpConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bgpDisabledOnResources = javaType.bgpDisabledOnResources().map({ args0 -> args0 }),
            connectedIPv4Subnets = javaType.connectedIPv4Subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ConnectedSubnetResponse.Companion.toKotlin(args0)
                })
            }),
            connectedIPv6Subnets = javaType.connectedIPv6Subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.ConnectedSubnetResponse.Companion.toKotlin(args0)
                })
            }),
            disabledOnResources = javaType.disabledOnResources().map({ args0 -> args0 }),
            exportRoutePolicyId = javaType.exportRoutePolicyId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            importRoutePolicyId = javaType.importRoutePolicyId().map({ args0 -> args0 }).orElse(null),
            mtu = javaType.mtu().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            staticRouteConfiguration = javaType.staticRouteConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.StaticRouteConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            vlanId = javaType.vlanId(),
        )
    }
}
