@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.managednetworkfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The L3IsolationDomain resource definition.
 * @property administrativeState Administrative state of the IsolationDomain. Example: Enabled | Disabled.
 * @property aggregateRouteConfiguration List of Ipv4 and Ipv6 route configurations.
 * @property annotation Switch configuration description.
 * @property connectedSubnetRoutePolicy Connected Subnet RoutePolicy
 * @property description L3 Isolation Domain description.
 * @property disabledOnResources List of resources the L3 Isolation Domain is disabled on. Can be either entire NetworkFabric or NetworkRack.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkFabricId Network Fabric ARM resource id.
 * @property optionBDisabledOnResources List of resources the OptionB is disabled on. Can be either entire NetworkFabric or NetworkRack.
 * @property provisioningState Gets the provisioning state of the resource.
 * @property redistributeConnectedSubnets Advertise Connected Subnets. Ex: "True" | "False".
 * @property redistributeStaticRoutes Advertise Static Routes. Ex: "True" | "False".
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetL3IsolationDomainResult(
    public val administrativeState: String,
    public val aggregateRouteConfiguration: AggregateRouteConfigurationResponse? = null,
    public val `annotation`: String? = null,
    public val connectedSubnetRoutePolicy:
    L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy? = null,
    public val description: String? = null,
    public val disabledOnResources: List<String>,
    public val id: String,
    public val location: String,
    public val name: String,
    public val networkFabricId: String,
    public val optionBDisabledOnResources: List<String>,
    public val provisioningState: String,
    public val redistributeConnectedSubnets: String? = null,
    public val redistributeStaticRoutes: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.managednetworkfabric.outputs.GetL3IsolationDomainResult):
            GetL3IsolationDomainResult = GetL3IsolationDomainResult(
            administrativeState = javaType.administrativeState(),
            aggregateRouteConfiguration = javaType.aggregateRouteConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.AggregateRouteConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            `annotation` = javaType.`annotation`().map({ args0 -> args0 }).orElse(null),
            connectedSubnetRoutePolicy = javaType.connectedSubnetRoutePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.L3IsolationDomainPatchPropertiesResponseConnectedSubnetRoutePolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            disabledOnResources = javaType.disabledOnResources().map({ args0 -> args0 }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            networkFabricId = javaType.networkFabricId(),
            optionBDisabledOnResources = javaType.optionBDisabledOnResources().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            redistributeConnectedSubnets = javaType.redistributeConnectedSubnets().map({ args0 ->
                args0
            }).orElse(null),
            redistributeStaticRoutes = javaType.redistributeStaticRoutes().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.managednetworkfabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
